ActiveRecord::Schema.define(:version => 1) do

  create_table "questions", :force => true do |t|
    t.column "quiz_id",  :integer
    t.column "position", :integer
    t.column "question", :text, :null => false
    t.column "answer",   :text, :null => false
  end

  add_index "questions", ["quiz_id"], 
    :name => "questions_quiz_id_index"
  add_index "questions", ["position"], 
    :name => "position"

  create_table "quizzes", :force => true do |t|
    t.column "name", :string,
      :default => "Nowy Quiz", :null => false
    t.column "session_id", :string, 
      :limit => 50, :default => "", :null => false
    t.column "created_at", :datetime,
      :null => false
  end

  add_index "quizzes", ["created_at"], :name => "created_at"

end