class Quiz < ActiveRecord::Base

  # Metoda dodana do powiązania np. quiz.questions.unmissed,
  # aby wyciągnać wszystkie pytania, które nie były nietrafione
  module AssociationExtension
    def unmissed right_keys
      cond = "id not in (#{right_keys})" unless right_keys.blank?
      find :all, :conditions => (cond || nil), :limit => 5
    end
  end

  has_many :questions, 
    :order     =>'position', 
    :dependent => :destroy, 
    :extend    => AssociationExtension

  # Odnajduje 20 ostatnio utworzonych quizów
  def self.recent
    find :all, :limit => 20, :order => "created_at desc"
  end

end