class PostsController < ApplicationController
  
  before_filter :find_post, 
    :only => [ :show, :download, :edit, :update, :destroy ]
  before_filter :check_permissions, :only => [ :update, :destroy ]
  
  def index
    @page_title = post_type.pluralize
    @post = model.new
    @posts = model.find :all
  end
  
  def new
    @page_title = "Nowy #{post_type}"
    @edit_on = true
    @post = model.new
  end

  def create
    @post = model.new params[:post]
    @post.creator = current_user
    @post.updated_by = @post.created_by
    if @post.save 
      flash[:notice] ='zapisano post.'
      redirect_to :action =>'index'
    else
      @page_title = "Nowy #{post_type}"
      @edit_on = true
      render :action =>'new'
    end
  end

  def show
  end

  def download
    filename = @post.attachment_filename.split(/\\/).last
    send_data @post.attachment.content, :filename => filename, 
      :type => @post.attachment_content_type, 
      :disposition =>'attachment'
  end
  
  def edit
    @edit_on = true
    render :action =>'show'
  end
  
  def update
    post = params[:post].merge(:updated_by => current_user)
    if @post.update_attributes post
      flash[:notice] ='Zmiany zostały zapisane.'
      redirect_to :action =>'show'
    else
      @edit_on = true
      render :action =>'show'
    end
  end

  def destroy
    @post.destroy
    flash[:notice] = "Post został usunięty."
    redirect_to :action =>'index'
  end
  
  private
  
    # Nazwa modelu powiązanego z kontrolerem. 
    # Do nadpisania w klasach pochodnych.
    def model_name;'Post'; end

    # 'Ludzka nazwa' modelu, jeśli różni się od aktualnej  
    # nazwy modelu.
    def post_type; model_name; end
    helper_method :post_type

    # Klasa modelu powiązana z kontrolerem.
    def model; eval model_name; end
  
    def find_post
      @post = model.find params[:id]
    end
    
    # Wstępne odfiltrowanie, chyba, że użytkownik ma prawo do edycji 
    # postu.
    def check_permissions
      unless can_edit? @post
        flash[:warning] = "Nie możesz edytować tego postu."
        redirect_to :action =>'show'
        return false
      end
    end
  
end