/* Ajax - zestaw narzędzi  */
/* Funkcje DOM  */

function replaceText(elem, text) {
  // Zastąp tekst wewnątrz elementu
  if (elem != null) {
    while(elem.firstChild)
      elem.removeChild(elem.firstChild);
    elem.appendChild(document.createTextNode(text));
  }
}

function getText(elem) {
  // Pobierz tekt znajdujący się wewnątrz elementu
  var text = "";
  if (elem != null)
    if (elem.childNodes)
      for (var i = 0; i < elem.childNodes.length; i++) {
        var childNode = elem.childNodes[i];
        if (childNode.nodeValue != null)
          text = text + childNode.nodeValue;
      }
  return text;
}

function getClientWidth() {
  // Pobierz szerokość widocznego okienka przeglądarki
  return self.innerWidth ? self.innerWidth :
    document.documentElement && document.documentElement.clientWidth ? document.documentElement.clientWidth :
    document.body ? document.body.clientWidth :
    0;
}

function getClientHeight() {
  // Pobierz wysokość widocznego okienka przeglądarki
  return self.innerHeight ? self.innerHeight :
    document.documentElement && document.documentElement.clientHeight ? document.documentElement.clientHeight :
    document.body ? document.body.clientHeight :
    0;
}

function getClientLeft() {
  // Pobierz lewą pozycję widocznego okienka przeglądarki
  return typeof self.pageXOffset != "undefined" ? self.pageXOffset :
    document.documentElement && document.documentElement.scrollLeft ? document.documentElement.scrollLeft :
    document.body.scrollLeft ? document.body.scrollLeft :
    0;
}

function getClientTop() {
  // Pobierz górną pozycję widocznego okienka przeglądarki
  return typeof self.pageYOffset != "undefined" ? self.pageYOffset :
    document.documentElement && document.documentElement.scrollTop ? document.documentElement.scrollTop :
    document.body.scrollTop ? document.body.scrollTop :
    0;
}

function getCookieData(cookieName) {
  var cookieData = document.cookie;
  var i = 0;
  var cEnd;
  while (i < cookieData.length) {
    var j = i + cookieName.length;
    if (cookieData.substring(i, j) == cookieName) {
      cEnd = cookieData.indexOf(";", j);
      if (cEnd == -1)
        cEnd = cookieData.length;
      return decodeURIComponent(cookieData.substring(j + 1, cEnd));
    }
    i++;
  }
  return "";
}
