function initRatings() {
  // Wyślij żądanie GET Ajaksa pobierające oceny
  ajaxSendRequest("GET", "ratingkit.php", handleinitRatingsRequest);
}

function handleinitRatingsRequest() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      // Zapamiętaj dane XML odpowiedzi z ocenami
      var ratings = request.responseXML.getElementsByTagName("rating");

      // Ustaw informację dla każdej oceny na stronie
      for (var i = 0; i < ratings.length; i++) {
        var id = getText(ratings[i].getElementsByTagName("id")[0]);

        // Pokaż wyniki głosowania tylko wtedy, kiedy zostało ustawione ciasteczko oceny
        if (getCookieData(id + "-rating") == "voted" && parseInt(getText(ratings[i].getElementsByTagName("votes")[0])) &&
          document.getElementById(id + "-info") != null) {
          var avg = getText(ratings[i].getElementsByTagName("avg")[0]);
          var votes = getText(ratings[i].getElementsByTagName("votes")[0]);

          // Wyświetl ilość głosów
          if (votes == "1")
            replaceText(document.getElementById(id + "-info"), "(" + votes + " głos)");
          else
            replaceText(document.getElementById(id + "-info"), "(" + votes + " głosy(ów)");

          // Wyświetl średnią ocenę
          document.getElementById(id + "-rating").style.width = Math.round(avg * 20) + "%";
        }
      }
    }
  }
  ajaxUpdateState();
}

function setRating(id, rating) {
  // Ustaw ocenę tylko wtedy kiedy ciasteczko oceny NIE zostało ustawione
  if (getCookieData(id + "-rating") != "voted") {
    // Wyświetl komunikat oczekiwania
    replaceText(document.getElementById(id + "-info"), "(Oddawanie głosu...)");

    // Wyślij żądanie POST zapisujące ocenę
    ajaxSendRequest("POST", "ratingkit.php",
      function() { handleSetRatingRequest(id); },
      "application/x-www-form-urlencoded; charset=UTF-8",
      "id=" + id + "&rating=" + rating);
  }
}

function handleSetRatingRequest(id) {
  if (request.readyState == 4) {
    if (request.status == 200) {
      // Zapamiętaj dane odpowiedzi ocen (przekstałć z formatu średniaOcena:ilośćGłosów)
      var rating = request.responseText.split(":");

      // Wyświetl ilość głosów
      if (rating[1] == "1")
        replaceText(document.getElementById(id + "-info"), "(" + rating[1] + " głos)");
      else
        replaceText(document.getElementById(id + "-info"), "(" + rating[1] + " głosy(ów)");

      // Wyświetl średnią ocenę
      document.getElementById(id + "-rating").style.width = Math.round(parseFloat(rating[0]) * 20) + "%";

      // Ustaw ciasteczko oceny w celu zabezpieczenia przed wielokrotnym głosowaniem
      document.cookie = id + "-rating=voted";
    }
  }
  ajaxUpdateState();
}
