// Zmienna animowanego obrazka
var waitImage;

function initInfoWindow(width, height) {
  // Wczytaj animowany obrazek
  waitImage = new Image();
  waitImage.src = "infowinkit_wait.gif";

  // Stwórz okienko informacyjne jako fragment dokumentu
  var docFragment = document.createDocumentFragment();
  var elemInfoWin = document.createElement("div");
  elemInfoWin.setAttribute("id", "infowin");
  elemInfoWin.style.width = width;
  elemInfoWin.style.height = height;
  elemInfoWin.onclick = function() {
    // Ukryj okienko informacyjne po kliknięciu
    hideInfoWindow();
    return false;
  };
  elemInfoWin.style.display = "none";
  docFragment.appendChild(elemInfoWin);

  // Dodaj okienko informacyjne do sekcji body strony
  var elemBody = document.getElementsByTagName("body")[0];
  elemBody.insertBefore(docFragment, elemBody.firstChild);
}

function showInfoWindow(infoURL, evt) {
  // Pobierz pozycję kliknięcia myszą
  if (!evt)
    evt = window.event;
  var xPos = 0, yPos = 0;
  if (evt.pageX || evt.pageY) {
    xPos = evt.pageX;
    yPos = evt.pageY;
  }
  else if (evt.clientX || evt.clientY) {
    xPos = evt.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
    yPos = evt.clientY + document.body.scrollTop + document.documentElement.scrollTop;
  }

  // Zmień pozycję i wyświetl okienko informacyjne włączając w to obrazek oczekiwania
  var elemInfoWin = document.getElementById("infowin");
  elemInfoWin.innerHTML = "<img src='infowinkit_wait.gif' alt='Loading...' />";
  elemInfoWin.style.display = "block";

  // Upewnij się, że okienko nie wychodzi poza ekran
  xPos = Math.min(Math.max(0, xPos), getClientWidth() - elemInfoWin.offsetWidth - 5);
  yPos = Math.min(Math.max(0, yPos), getClientHeight() - elemInfoWin.offsetHeight - 5);
  elemInfoWin.style.left = xPos + "px";
  elemInfoWin.style.top = yPos + "px";

  // Wyślij żądanie ajaksa w celu pobrania nowej zawartości
  ajaxSendRequest("GET", infoURL, handleContentRequest);

  return false;
}

function handleContentRequest() {
  if (request.readyState == 4) {
    if (request.status == 200) {
      // Wyświetl dane odpowiedzie w okienku informacyjnym
      showInfoContent(request.responseText);
      document.onkeypress = handleKeyPress;
    }
    else
      // Błąd żądania - wyświetl komunikat błędu
      showInfoContent("Nie można znaleźć żądanych informacji.");
  }
  ajaxUpdateState();
}

function showInfoContent(infoHTML) {
  // Wyświetl zawartość w okienku informacyjnym
  document.getElementById("infowin").innerHTML = infoHTML;
}

function hideInfoWindow() {
  // Ukryj okienko informacyjne i wyłącz wykrywanie naciśnięcia klawiszy
  document.getElementById("infowin").style.display = "none";
  document.onkeypress = "";

  return false;
}

function handleKeyPress(evt) {
  // Ukryj okienko informacyjne po naciśnięciu Return lub spacji
  evt = evt ? evt : (event ? event : null);
  if (evt) {
    var key = evt.charCode ? evt.charCode : evt.keyCode;
    if (key == 13 || key == 32)
      hideInfoWindow();
  }

  return false;
}
