/* Ajax - zestaw narzędzi */
/* Funkcje do sprawdzania poprawności */

function validateNonEmpty(inputControl, helpControl) {
  // Sprawdź czy pole zawiera jakikolwiek tekst
  return validateRegEx(/.+/,
    inputControl.value, helpControl,
    "Proszę wprowadzić wartość.");
}

function validateInteger(inputControl, helpControl) {
  // Najpierw sprawdź czy pole zawiera dane
  if (!validateNonEmpty(inputControl, helpControl))
    return false;

  // Następnie sprawdź czy w polu wpisana jest liczba całkowita
  return validateRegEx(/^[-]?\d*$/,
    inputControl.value, helpControl,
    "Proszę wprowadzić liczbę całkowitą.");
}

function validateNumber(inputControl, helpControl) {
  // Najpierw sprawdź czy pole zawiera dane
  if (!validateNonEmpty(inputControl, helpControl))
    return false;

  // Potem sprawdź czy w polu wpisana jest liczba
  return validateRegEx(/^[-]?\d*\.?\d*$/,
    inputControl.value, helpControl,
    "Proszę wprowadzić liczbę.");
}

function validateZipCode(inputControl, helpControl) {
  // Najpierw sprawdź czy pole zawiera dane
  if (!validateNonEmpty(inputControl, helpControl))
    return false;

  // Potem sprawdź czy w polu wpisany jest kod pocztowy
  return validateRegEx(/^\d{5}$/,
    inputControl.value, helpControl,
    "Proszę wprowadzić pięciocyfrowy kod pocztowy.");
}

function validatePhone(inputControl, helpControl) {
  // Najpierw sprawdź czy pole zawiera dane
  if (!validateNonEmpty(inputControl, helpControl))
    return false;

  // Potem sprawdź czy w polu wpisany jest numer telefonu
  return validateRegEx(/^\d{3}-\d{3}-\d{4}$/,
    inputControl.value, helpControl,
    "Prosze wprowadzić numer telefonu (na przykład, 123-456-7890).");
}

function validateEmail(inputControl, helpControl) {
  // Najpierw sprawdź czy pole zawiera dane
  if (!validateNonEmpty(inputControl, helpControl))
    return false;

  // Potem sprawdź czy w polu wpisany jest adres e-mail
  return validateRegEx(/^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/,
    inputControl.value, helpControl,
    "Proszę wprowadzić adres e-mail (na przykład, john@doe.com).");
}

function validateDate(inputControl, helpControl) {
  // Najpierw sprawdź czy pole zawiera dane
  if (!validateNonEmpty(inputControl, helpControl))
    return false;

  // Potem sprawdź czy w polu wpisana jest data
  return validateRegEx(/(0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\d\d/,
    inputControl.value, helpControl,
    "Proszę wprowadzić datę (na przykład, 14.01.1975).");
}

function validateRegEx(regex, input, helpControl, helpMessage) {
  if (!regex.test(input)) {
    if (helpControl != null)
      helpControl.innerHTML = helpMessage;
    return false;
  }
  else {
    if (helpControl != null)
      helpControl.innerHTML = "";
    return true;
  }
}
