/* Ajax -  zestaw narzędzi */
/* Funkcje Ajaksa */

var request;

// Stwórz obiekt XMLHttpRequest
function ajaxCreateRequest() {
  // Na początku wypróbu obiekt XMLHttpRequest
  if (window.XMLHttpRequest) {
    try {
      request = new XMLHttpRequest();
    } catch(e) {
      request = null;
    }
  // Teraz wypróbuj wersję ActiveX (IE)
  } else if (window.ActiveXObject) {
    try {
      request = new ActiveXObject("Msxml2.XMLHTTP");
    // W przypadku starszych wersji IE wypróbuj starszy obiekt ActiveX
    } catch(e) {
      try {
        request = new ActiveXObject("Microsoft.XMLHTTP");
      } catch(e) {
        request = null;
      }
    }
  }
  // Jeśli wszystko zawiedzie wyczyść obiekt
  else {
    request = null;
  }
}

function ajaxSendRequest(type, url, handler, postDataType, postData) {
  if (request == null)
    // Stwórz nowe żądanie
    ajaxCreateRequest();
  else {
    // Usuń poprzednie żądanie
    request.abort();
    ajaxCreateRequest();
  }  

  if (request == null) {
    alert("Błąd tworzenia obiektu żądania Ajaksa.\n" + "Sczegóły: " + e);
  }
  else {
    try {
      request.onreadystatechange = handler;
      request.open(type, url, true); // Zawsze asynchroniczny (true)
      if (type.toLowerCase() == "get") {
        // Wyślij żądanie GET; dane nie są przekazywane
        request.send(null);
      } else {
        // Wyślij żądanie POST; ostatnim argumentem są dane
        request.setRequestHeader("Content-Type", postDataType);
        request.send(postData);
      }
    } catch(e) {
      alert("Błąd komunikacji z serwerem.\n" + "Szczegóły: " + e);
    }
  }
}

function ajaxUpdateState() {
  var stateElem = document.getElementById("ajaxState");
  if (stateElem) {
    // Ostyluj element stanu
    stateElem.style.fontSize = "small";
    stateElem.style.border = "1px solid";
    stateElem.style.textAlign = "center";

    switch (request.readyState) {
    // NIEZAINICJALIZOWANE - Żądanie nie zostało jeszcze otwarte
    case 0:
      stateElem.style.backgroundColor = "#FFFFFF"; // biały
      stateElem.innerHTML = "Żądanie niezainicjalizowane.";
      break;
    // WCZYTYWANIE - Żądanie nie zostało jeszcze wysłane
    case 1:
      stateElem.style.backgroundColor = "#999999"; // szary
      stateElem.innerHTML = "Żądanie zainicjalizowane.";
      break;
    // WCZYTANE - Żądanie zostało wysłane
    case 2:
      stateElem.style.backgroundColor = "#FF0000"; // czerwony
      stateElem.innerHTML = "Czekam na odpowiedź...";
      break;
    // INTERAKTYWNE - Wczytywane są dane odpowiedzi
    case 3:
      stateElem.style.backgroundColor = "#FFFF00"; // żółty
      stateElem.innerHTML = "Wczytywanie odpowiedzi...";
      break;
    // ZAKOŃCZONE - Żądanie/odpowiedź jest kompletna
    case 4:
      if (request.status == 200) {
        // Wszystko w porządku
        stateElem.style.backgroundColor = "#00FF00"; // zielony
        stateElem.innerHTML = "Żądanie zakończone!";
      } else {
        // Wystąpił błąd
        stateElem.style.backgroundColor = "#FF8800"; // pomarańczowy
        stateElem.innerHTML = "Błąd żądania!";
      }
      break;
    }
  }
}
