<?php
$filename = "ratings.xml";

// Wczytaj oceny
if (file_exists($filename)) {
  $rawRatings = file_get_contents($filename);
}
else {
  $rawRatings = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
  $rawRatings .= "<ratings></ratings>";
}
$xml = new SimpleXmlElement($rawRatings);

// Jeśli to żądanie odczytu ocen, odeślij dane ocen
if ($_REQUEST["id"] == "" || $_REQUEST["rating"] == "") {
  header('Content-Type: text/xml');
  if ($xml->rating != null)
    echo $xml->asXML();
}
// Jeśli została wysłana ocena, uaktualnij odpowiedni wpis
else {
  // Zobacz czy ocena istnieje w danych XML, jeśli tak, uaktualnij ją
  $ratingExists = false;
  if ($xml->children()) {
    foreach ($xml->rating as $rating) {
      if ($rating->id == $_REQUEST["id"]) {
        $ratingExists = true;
        $rating->avg = strval(((floatval($rating->avg) * floatval($rating->votes)) +
          floatval($_REQUEST["rating"])) / (floatval($rating->votes) + 1.0));
        $rating->votes = strval(intval($rating->votes) + 1);

        // Zwróć informację o ocenie
        echo $rating->avg . ":" . $rating->votes;

        break;
      }
    }
  }

  // Jeśli oceny nie ma w danych XML, dodaj ją jako węzeł potomny
  if (!$ratingExists) {
    $rating = $xml->addChild("rating");
    $rating->addChild("id", $_REQUEST["id"]);
    $rating->addChild("avg", $_REQUEST["rating"]);
    $rating->addChild("votes", "1");

    // Zwróć informację o ocenie
    echo $_REQUEST["rating"] . ":" . "1";
  }

  // Została przesłana ocena, więc zapisz ją
  $file = fopen($filename, 'w');
  fwrite($file, $xml->asXML());
  fclose($file);
}
?>
