// Animowany obrazek oczekiwania
var waitImage;

function initModal() {
  // Wczytaj wcześniej obrazek oczekiwania
  waitImage = new Image();
  waitImage.src = "modalimgkit_wait.gif";

  // Umieść we wszystkich łączach brazków wywołanie funkcji showModal() po kliknięciu.
  var links = document.getElementsByTagName("a");
  for(var i = 0; i < links.length; i++) {
    if (links[i].getAttribute("href") && /gif|jpe?g|png$/.test(links[i].getAttribute("href"))) {
      links[i].onclick = function() {
        showModal(this);
        return false;
      };
    }
  }

  // Stwórz okienko jako fragment dokumentu włączając w to zawartość z obrazkiem
  var docFragment = document.createDocumentFragment();
  var elemModalWin = document.createElement("div");
  elemModalWin.setAttribute("id", "modalwin");
  elemModalWin.style.display = "none";
  docFragment.appendChild(elemModalWin);
  var elemModalContent = document.createElement("div");
  elemModalContent.setAttribute("id", "modalcontent");
  elemModalContent.onclick = function() {
    hideModal();
    return false;
  };
  elemModalContent.style.display = "none";
  var elemModalImg = document.createElement("img");
  elemModalImg.setAttribute("id", "modalimg");
  elemModalImg.setAttribute("alt", "Click to close.");
  elemModalContent.appendChild(elemModalImg);
  docFragment.insertBefore(elemModalContent, elemModalWin.nextSibling);

  // Dodaj okienko do sekcji body strony
  var elemBody = document.getElementsByTagName("body")[0];
  elemBody.insertBefore(docFragment, elemBody.firstChild);

  // Dołącz funkcje obsługi zdarzenia resize i scroll do okienka przeglądarki
  self.onresize = handleResize;
  self.onscroll = handleScroll;
}

function showModal(elemLink) {
  // Zmień rozmiar i pozycję okienka oraz wyświetl przezroczyste szare tło
  var elemModalWin = document.getElementById("modalwin");
  elemModalWin.style.left = getClientLeft() + "px";
  elemModalWin.style.top = getClientTop() + "px";
  elemModalWin.style.width = getClientWidth() + "px";
  elemModalWin.style.height = getClientHeight() + "px";
  elemModalWin.style.display = "block";

  // Wczytaj nowy obrazek do wyświetlenia
  var image = new Image();
  image.onload = function() {
    // Powczytaniu wyświetl nowy obrazek
    showImage(image);
    document.onkeypress = handleKeyPress;
    return false;
  };
  image.src = elemLink.href;

  // Jeśli nowy obrazek nie został jeszcze wczytanym pokaż obrazek oczekiwania
  if (!image.complete)
    showImage(waitImage);
}

function showImage(image) {
  // Zmień pozycję i wyświetl zawartość z obrazkiem
  document.getElementById("modalimg").src = image.src;
  var left = getClientLeft() + ((getClientWidth() - image.width) / 2);
  var top = getClientTop() + ((getClientHeight() - image.height) / 2);
  var elemModalContent = document.getElementById("modalcontent");
  elemModalContent.style.left = (left < 0 ? 0 : left) + "px";
  elemModalContent.style.top = (top < 0 ? 0 : top) + "px";
  elemModalContent.style.display = "block";
}

function hideModal() {
  // Ukryj okienko
  document.getElementById("modalwin").style.display = "none";
  document.getElementById("modalcontent").style.display = "none";
  document.onkeypress = "";
}

function handleKeyPress(evt) {
  // Ukryj okienko po naciśnięciu Return lub spacji
  evt = evt ? evt : (event ? event : null);
  if (evt) {
    var key = evt.charCode ? evt.charCode : evt.keyCode;
    if (key == 13 || key == 32)
      hideModal();
  }
  return false;
}

function handleResize() {
  // Zmień rozmiar okienka na podstawie rozmiaru okienka przeglądarki
  document.getElementById("modalwin").style.width = getClientWidth() + "px";
  document.getElementById("modalwin").style.height = getClientHeight() + "px";
}

function handleScroll() {
  // Zmień pozycję okienka na podstawie pozycji okna przeglądarki
  document.getElementById("modalwin").style.left = getClientLeft() + "px";
  document.getElementById("modalwin").style.top = getClientTop() + "px";
}
