/*
 * konwertujemy znak na liczb dziesitn 
 * i odsyamy j klientowi.
 */

package com.oreilly.ajax.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AjaxResponseServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {

        String key = req.getParameter("key");
        if (key != null) {
            // pobieramy pierwszy znak z parametru key
            int keyInt = key.charAt(0);
            String decimalString = Integer.toString(keyInt); 
            // przygotowujemy odpowied
            res.setContentType("text/xml");
            res.setHeader("Cache-Control", "no-cache");
            // wysyamy acuch odpowiedzi
            res.getWriter().write(decimalString);
        }
        else {
            // jeli dla klawisza chcemy zwrci warto null, zwracamy znak zapytania
            res.setContentType("text/xml");
            res.setHeader("Cache-Control", "no-cache");
            res.getWriter().write("?");
        }
    }
}