UserValidator = {};

UserValidator.initialize = function(formId, modeVal, fieldNum, submitId)
{
	UserValidator.currentSelector = '';
	UserValidator.currentForm = formId;
	UserValidator.mode = modeVal;
	UserValidator.fieldNumToValidate = fieldNum;
	UserValidator.submitId = submitId;
}

UserValidator.setMode = function(modeVal)
{
	UserValidator.mode = modeVal;
	Utilities.getElement( UserValidator.submitId ).value = modeVal;
	Utilities.getElement( UserValidator.submitId ).disabled = true;
	Utilities.getElement( UserValidator.currentForm ).action += "?mode="+ modeVal;
}

UserValidator.validate = function(selector, value)
{
	if(selector != '' && value != '')
	{
		UserValidator.currentSelector = selector;
		
		var url = "serviceConnector.php?object=UserManager&method=verifyUserInformation&params="+ selector +","+ value;
		AjaxUpdater.Update("GET", url, UserValidator.onValidation);
	}
	else if(selector != '' && value == '')
	{
		Utilities.getElement( selector ).style.backgroundColor = '#ffffff';
		Utilities.getElement( selector +"Message" ).innerHTML = '';
	}
}

UserValidator.onValidation = function()
{
	if(Ajax.checkReadyState('loading') == "OK")
	{
		var color = '#ffffff';
		if(Ajax.getResponse().firstChild.data == 'success')
		{
			color = '#ff9999';
			Utilities.getElement( UserValidator.currentSelector +"Message" ).innerHTML = 'Ju w uyciu.';
		}
		else
		{
			color = '#ccff99';
			Utilities.getElement( UserValidator.currentSelector  +"Message" ).innerHTML = 'OK';
			UserValidator.fieldNumToValidate--;
		}
		Utilities.getElement( UserValidator.currentSelector ).style.backgroundColor = color;
		
		if(UserValidator.fieldNumToValidate == 0)
		{
			Utilities.getElement( UserValidator.submitId ).disabled = false;
		}
	}
}