function Historian(url)
{
	this.toString = function() { return "Historian"; }
	this.collection = new Array();
	
	this.push = function(_index)
	{
		if(!this.containsValue(this.collection, _index))
		{
			this.collection.push(_index);
			this.save(this.collection, 1, "/", url, false);
		}
	}
	
	this.save = function(value, days, path, domain, secure)
	{
		var expdate = new Date(); 
		expdate.setTime(expdate.getTime() + days *24*60*60*1000); 
		
		document.cookie= "history=" + escape(value) +
			((expdate) ? "; expires=" + expdate.toGMTString() : "") +
			((path) ? "; path=" + path : "") +
			((domain) ? "; domain=" + domain : "") +
			((secure) ? "; secure" : "");
	}
	
	this.getSaved = function()
	{
		var dc = document.cookie;
		var prefix = "history=";
		var begin = dc.indexOf(prefix);
		if (begin == -1)
		{
			return null;
		}
		
		return unescape(dc.substring(begin + prefix.length, dc.length));
	}
	
	try
	{
		this.collection = this.getSaved().split(",");
	}
	catch(err)
	{
		this.collection = new Array();
	}
	
	this.clear = function(path, domain)
	{
		if(this.getSaved())
		{
			document.cookie = "history=" +
				((path) ? "; path=" + path : "") +
				((domain) ? "; domain=" + domain : "") +
				"; expires=Thu, 01-Jan-70 00:00:01 GMT";
		}
	}
	
	this.containsValue = function(_arr, _val)
	{
		for(var i=0; i<_arr.length; i++)
		{
			if(_arr[i] == _val)
			{
				return true;
				break;
			}
		}
		return false;
	}
	
}