function Tree(data)
{
	this.data = data;
	this.childArray = new Array();
	this.tree = '';
}

Tree.prototype.display = function()
{
	var tree = Utilities.createElement("div", {
      id: 'tree',
	  innerHTML: this.traverse(this.data, 0)
      });
	
	return tree;
}

Tree.prototype.traverse = function(branch, depth)
{
	if(branch.nodeName.charCodeAt(0) != 35)
	{
		var id = branch.parentNode.nodeName+'_'+branch.nodeName+'_'+depth;
		this.childArray.push(id);
		
		if(branch.childNodes.length == 0)
		{
			this.tree += "<img src='img/folder_empty.gif' border='0' class='folder'>";
		}
		else
		{
			this.tree += "<a href='#' onclick=\"javascript:Utilities.toggle('"+ id +"');TreeManager.toggleImage('expand_collapse_"+ id +"');\" class='expand_collapse' onfocus='javascript:if(this.blur) this.blur();'>";
			this.tree += "<img src='img/folder_o.gif' id='expand_collapse_"+ id +"' border='0' class='folder'></a>";
		}
		
		var action = branch.getAttribute("action");
		this.tree += "<a href=\"#\" onclick=\"javascript:"+ action +"\" class='container'>"+ branch.nodeName +"</a>";
		
		this.tree += "<ul><li id='"+id+"'>";
		for(var i=0; i<branch.childNodes.length; i++)
		{
			this.traverse(branch.childNodes[i], depth);
			depth++;
		}
		this.tree += "</li></ul>";
    }
    else
	{
		var value = branch.nodeValue;
		if(value != undefined)
		{
			this.tree += "<div class='value'>"+ value +"</div>";
		}
		return;
	}
	return this.tree;
}

Tree.prototype.toggle = function()
{
	for(var i=0; i<this.childArray.length; i++)
	{
		Utilities.toggle(this.childArray[i]);
		TreeManager.toggleImage("expand_collapse_"+this.childArray[i]);
	}
}