Accordion = {};

Accordion.initialize = function()
{
	panels = new Array();
	expandedPanel = 0;
}
Accordion.initialize();

Accordion.display = function()
{
	try
	{
		if(Ajax.checkReadyState('loading') == "OK")
		{
			var accordion = Utilities.createElement("div", {id:'accordion'});
			var p = Ajax.getResponse().getElementsByTagName('panel');
			for(var i=0; i<p.length; i++)
			{
				var title = Ajax.getResponse().getElementsByTagName('title')[i].firstChild.data;
				var content = Ajax.getResponse().getElementsByTagName('content')[i].firstChild.data;
				if(p[i].getAttribute('expanded')) { expandedPanel = i; }
				panels.push( new Panel(i, title, content) );
				
				Utilities.appendChild(accordion, panels[i].display());
			}
			
			Utilities.appendChild(document.body, accordion);
			Accordion.toggle(expandedPanel);
		}
	}
	catch(err)
	{
		document.write(err);
	}
}

Accordion.toggle = function(id)
{
	for(var i=0; i<panels.length; i++)
	{
		if(panels[i].id == id)
		{
			panels[i].expand();
		}
		else
		{
			panels[i].collapse();
		}
	}
}