function makeRequest(url, callbackMethod) 
{
	if(window.XMLHttpRequest)
	{
		request = new XMLHttpRequest();
	}
	else if(window.ActiveXObject)
	{
		request = new ActiveXObject("Msxml2.XMLHTTP");
	}
	
	sendRequest(url, callbackMethod);
}

function sendRequest(url, callbackMethod)
{
	request.onreadystatechange = callbackMethod;
	request.open("GET", url, true);
	request.send(null);
} 

function checkReadyState(obj, id)
{
	switch(obj.readyState)
	{
		case 0:
			document.getElementById(id).innerHTML = "Trwa wysyanie dania...";
			break;
		case 1:
			document.getElementById(id).innerHTML = "Trwa wczytywanie odpowiedzi...";
			break;
		case 2:
			document.getElementById(id).innerHTML = "Odpowied wczytana...";
			break;
		case 3:
			document.getElementById(id).innerHTML = "Odpowied gotowa...";
			break;
		case 4:
			document.getElementById(id).innerHTML = "";
			return (obj.status == 200);
			break;
		default:
			document.getElementById(id).innerHTML = "Wystpi nieoczekiwany bd.";
	}
}

function onXMLResponse()
{
	if(checkReadyState(request, 'loading') == true)
	{
		var response = request.responseXML.documentElement;
		
		document.getElementById("body").innerHTML = "<div id='icon'></div>";
		var categories = response.getElementsByTagName('category');
		for(var i=0; i<categories.length; i++)
		{
			document.getElementById("body").innerHTML += "<div id='header'>&nbsp;"+ response.getElementsByTagName('category')[i].firstChild.data +"</div>";
		}
		
		var row = response.getElementsByTagName('row');
		for(var i=0; i<row.length; i++)
		{
			var action = response.getElementsByTagName('items')[i].getAttribute('action');
			var icon = response.getElementsByTagName('items')[i].getAttribute('icon');
			var items = response.getElementsByTagName('items')[i].childNodes;
			document.getElementById("body").innerHTML += "<div id='icon'><img src='"+ icon +"'/></div>";
			for(var j=0; j<items.length; j++)
			{
				for(var k=0; k<items[j].childNodes.length; k++)
				{
					document.getElementById("body").innerHTML += "<div id='item' onclick=\""+ action +"\">&nbsp;"+ items[j].childNodes[k].nodeValue +"</div>";
				}
			}
		}
	}
}

function onJSONResponse()
{
	if(checkReadyState(request, 'loading') == true)
	{
		eval("var response = ("+request.responseText+")");
		
		document.getElementById("body").innerHTML = "<div id='icon'></div>";
		for(var i in response.data.categories.category)
		{
			document.getElementById("body").innerHTML += "<div id='header'>&nbsp;"+ response.data.categories.category[i] +"<div/>";
		}
		
		for(var i in response.data.row.items)
		{
			document.getElementById("body").innerHTML += "<div id='icon'><img src='"+ response.data.row.items[i].icon +"'/></div>";
			
			for(var j in response.data.row.items[i].item)
			{
				document.getElementById("body").innerHTML += "<div id='item' onclick=\""+ response.data.row.items[i].action +"\">&nbsp;"+ response.data.row.items[i].item[j] +"</div>";
			}
		}
	}
}