function Panel(id, title, content)
{
	this.id = id;
	this.title = title;
	this.content = content;
}

Panel.prototype.display = function()
{
	var panel = Utilities.createElement("div");
	
	var header = Utilities.createElement("div", {
		className: 'header',
		onclick: this.toggle(this.id)
		});
	
	var title = Utilities.createElement("div", {
		className: 'title',
		innerHTML: this.title
		});
	
	var content = Utilities.createElement("div", {
		id: 'content_'+ this.id,
		className: 'content',
		innerHTML: this.content
		});
	
	Utilities.appendChild(panel, Utilities.appendChild(header, title), content);
	return panel;
}

Panel.prototype.toggle = function(id)
{
	return function()
	{
		Accordion.toggle(id);
	}
}

Panel.prototype.collapse = function()
{
	Utilities.getElement('content_'+ this.id).style.display = 'none';
}

Panel.prototype.expand = function(id)
{
	Utilities.getElement('content_'+ this.id).style.display = '';
}