function DataRow(id, items, action, parity, icon)
{
	this.id = id;
	this.icon = icon;
	this.items = this.getAllItems(items);
	this.action = action;
	this.parity = parity;
}

DataRow.prototype.display = function()
{
	var row = Utilities.createElement("div", {
      id: 'row_'+ this.id,
      className: 'row_'+this.parity,
	  onclick: this.getAction(this.action),
	  onmouseover: this.rollOver('row_'+ this.id),
	  onmouseout: this.rollOut('row_'+ this.id)
      });
	
	for(var i=0; i<this.items.length; i++)
	{
		Utilities.appendChild(row, this.items[i]);
	}
	return row;
}

DataRow.prototype.toggle = function(id)
{
	return function()
	{
		Utilities.toggle(id);
	}
}

DataRow.prototype.getAction = function(action)
{
	return function()
	{
		eval(action)
	}
}

DataRow.prototype.getAllItems = function(items)
{
	var columns = new Array();
	for(var i=0; i<items.length; i++)
	{
		for(var j=0; j<items[i].childNodes.length; j++)
		{
			var copy = StringUtil.trim(items[i].childNodes[j].nodeValue, 50);
			columns.push(new  DataColumn(j, copy).display());
		}
	}
	return columns;
}

DataRow.prototype.rollOver = function(id)
{
	return function()
	{
		Utilities.getElement(id).style.backgroundColor = '#999';
		Utilities.getElement(id).style.cursor = 'pointer';
	}
}

DataRow.prototype.rollOut = function(id)
{
	var _this = this;
	return function()
	{
		if(_this.parity == "even")
		{
			Utilities.getElement(id).style.backgroundColor = '#eaeaea';
		}
		else
		{
			Utilities.getElement(id).style.backgroundColor = '#fff';
		}
		Utilities.getElement(id).style.cursor = 'none';
	}
}