DragDrop = {};

DragDrop.initialize = function(className)
{
	DragDrop.className = className;
	DragDrop.currentItem = '';
	document.onmousedown = DragDrop.onmousedown;
	document.onmouseup = DragDrop.onmouseup;
}

DragDrop.onmousedown = function(evt)
{
	var evt = DragDrop.getEvent(evt);
	if(evt != null)
	{
		var t = DragDrop.getTarget(evt);
		if(t.className == DragDrop.className)
		{
			if (!t.isDragging)
			{
				DragDrop.startDrag(t, evt.clientX, evt.clientY);
			}
		}
	}
}

DragDrop.onmouseup = function(evt)
{
	var evt = DragDrop.getEvent(evt);
	if(evt != null)
	{
		var t = DragDrop.getTarget(evt);
		if(t.className == DragDrop.className +' dragging')
		{
			DragDrop.stopDrag(t);
		}
	}
}

DragDrop.onmousemove = function(evt)
{
	var evt = DragDrop.getEvent(evt);
	if(evt != null)
	{
		var t = DragDrop.getTarget(evt);
		if(t.className == DragDrop.className +' dragging')
		{
			DragDrop.dragTo(t, evt.clientX, evt.clientY);
		}
	}
}

DragDrop.startDrag = function(_this, mouseX, mouseY)
{
	_this.orgParent = _this.parentNode;
	DragDrop.currentItem = _this;
	_this.isDragging = true;
	
	// Get coordinates
	var pos = Utils.getXY(_this);
	var x = pos.x;
	var y = pos.y;
	var w = _this.offsetWidth;
	var h = _this.offsetHeight;
	_this.dragOffsetX = mouseX - x;
	_this.dragOffsetY = mouseY - y;
	
	// Create dummy
	var dummy = Utils.createElement("div", {id:'drag_dummy'});
	dummy.style.height = (h) + 'px';
	dummy.style.width = (w) + 'px';
	Utils.appendChild(document.body, dummy);
	
	// Convert to drag class
	_this.className = DragDrop.className+' dragging';
	_this.style.position = 'absolute';
	_this.style.left = x + 'px';
	_this.style.top = y + 'px';
	_this.style.width = w + 'px';
	_this.style.height = h + 'px';
	Utils.changeOpac(25, _this.id);
	
	// Replace with dummy
	_this.parentNode.replaceChild(dummy, _this);
	document.body.appendChild(_this);
	
	Utils.addListener(document, "mousemove", DragDrop.dragTo);
}

DragDrop.dragTo = function(evt)
{
	_this = DragDrop.currentItem;
	var evt = DragDrop.getEvent(evt);
	mouseX = evt.clientX;
	mouseY = evt.clientY;
	
	_this.style.left = (mouseX - _this.dragOffsetX) + 'px';
	_this.style.top = (mouseY - _this.dragOffsetY) + 'px';
	
	var dummy = Utils.ge('drag_dummy');
	var el = DragDrop.getNewPositionElement(_this, mouseX, mouseY);
	if(el != null)
	{
		el.parentNode.insertBefore(dummy, el);
	}
	else
	{
		
		_this.orgParent.appendChild(dummy);
	}
}

DragDrop.stopDrag = function(_this)
{
	_this.className = DragDrop.className;
	var dummy = Utils.ge('drag_dummy');
	dummy.parentNode.replaceChild(_this, dummy);
	
	_this.isDragging = false;
	_this.style.position = '';
	_this.style.left = '';
	_this.style.top = '';
	_this.style.width = '';
	_this.style.height = '';
	
	Utils.removeListener(document, "mousemove", DragDrop.dragTo);
	Utils.changeOpac(100, _this.id);
	DragDrop.currentItem = '';
}

// Prywatne
DragDrop.getEvent = function(evt)
{
	if(!evt)
	{
		var evt = window.event;
	}
	return evt;
}

DragDrop.getTarget = function(evt)
{
	return t = (evt.target) ? evt.target : evt.srcElement;
}

DragDrop.getNewPositionElement = function(_this, mx, my)
{
	var target = null;
	var y = null;
	var ly = null;
	
	var p = _this.orgParent;
	for(var i in p.childNodes)
	{
		if(p.childNodes[i] != undefined)
		{
			if(p.childNodes[i].id != 'drag_dummy' && p.childNodes[i].id != undefined)
			{
				var pos = Utils.getXY(p.childNodes[i]);
				y = pos.y;
				h = p.childNodes[i].offsetHeight;
				
				if(my<(y+h) && (target == null || y < ly))
				{
					target = p.childNodes[i];
					ly = y;
				}
			}
		}
	}
	return target;
}