Utils = {};

Utils.ge = function(id)
{
	return document.getElementById(id);
}

Utils.toggle = function(id)
{
	document.getElementById(id).style.display = ( document.getElementById(id).style.display == 'none' ) ? '' : 'none';
}

Utils.toggleContent = function(id, content, content2)
{
	document.getElementById(id).innerHTML = ( document.getElementById(id).innerHTML == content ) ? content2 : content;
}

Utils.debug = function(val)
{
	Utils.ge('debug').innerHTML += val +"<br/>";
}

Utils.createElement = function(e, obj)
{
	var a = document.createElement(e);
	for(prop in obj)
	{
		a[prop] = obj[prop];
	}
	return a;
}

Utils.appendChild = function()
{
	if(this.appendChild.arguments.length > 1)
	{
		var a = this.appendChild.arguments[0];
		for(i=1; i<this.appendChild.arguments.length; i++)
		{
			if(arguments[i])
			{
				a.appendChild(this.appendChild.arguments[i]);
			}
		}
		return a;
	}
	else
	{
		return null;
	}
}

Utils.getXY = function(el)
{
	var x = el.offsetLeft;
	var y = el.offsetTop;
	if(el.offsetParent != null)
	{
		var pos = Utils.getXY(el.offsetParent);
		x += pos.x;
		y += pos.y;
	}
	return {x: x, y: y}
}

Utils.Tween = function(elementId, finalPosition, direction)
{
	var element = Utils.ge(elementId);
	if(direction == null)
	{
		if(parseInt(element.style.left) > finalPosition)
		{
			direction = 'left';
		}
		else
		{
			direction = 'right';
		}
	}
	
	// Animate both directions
	//printfire("element.style.left: "+parseInt(element.style.left));
	//printfire("finalPosition: "+finalPosition);
	//printfire("direction: "+direction);
	
	if(direction == 'left')
	{
		if(parseInt(element.style.left) > finalPosition)
		{
			element.style.left = parseInt(element.style.left) + (finalPosition/8) +'px';
			setTimeout("Utils.Tween('"+ elementId +"', '"+ finalPosition +"', '"+ direction +"')", 2);
		}
		else
		{
			element.style.left = finalPosition +'px';
		}
	}
	else if(direction == 'right')
	{
		if(parseInt(element.style.left) < finalPosition)
		{
			if(finalPosition == 0)
			{
				element.style.left = parseInt(element.style.left) - (-10) +'px';
			}
			else
			{
				element.style.left = parseInt(element.style.left) - (finalPosition/8) +'px';
			}
			setTimeout("Utils.Tween('"+ elementId +"', '"+ finalPosition +"', '"+ direction +"')", 2);
		}
		else
		{
			element.style.left = finalPosition +'px';
		}
	}
}

Utils.addListener = function(obj, eventName, listener)
{
	if (obj.attachEvent)
	{
		obj.attachEvent("on"+eventName, listener);
	}
	else if(obj.addEventListener)
	{
		obj.addEventListener(eventName, listener, false);
	}
	else
	{
		return false;
	}
	return true;
}


Utils.removeListener = function(obj, eventName, listener)
{
	if(obj.detachEvent)
	{
		obj.detachEvent("on"+eventName, listener);
	}
	else if(obj.removeEventListener)
	{
		obj.removeEventListener(eventName, listener, false);
	}
	else
	{
		return false;
	}
	
	return true;
}

Utils.fade = function(id, opacStart, opacEnd, millisec, callback)
{
	Utils.changeOpac(0, id);
    var speed = Math.round(millisec / 100);
    var timer = 0;

    if(opacStart > opacEnd)
	{
        for(i = opacStart; i >= opacEnd; i--)
		{
            setTimeout("Utils.changeOpac(" + i + ",'" + id + "'," + opacEnd + ",'" + callback + "')",(timer * speed));
            timer++;
        }
    }
	else if(opacStart < opacEnd)
	{
        for(i = opacStart; i <= opacEnd; i++)
        {
            setTimeout("Utils.changeOpac(" + i + ",'" + id + "'," + opacEnd + ",'" + callback + "')",(timer * speed));
            timer++;
        }
    }
}

Utils.changeOpac = function(opacity, id, endPoint, callback)
{
	var object = Utils.ge(id).style;
    object.opacity = (opacity / 100);
    object.MozOpacity = (opacity / 100);
    object.KhtmlOpacity = (opacity / 100);
    object.filter = "alpha(opacity=" + opacity + ")";
	
	if(opacity == endPoint && callback != null)
	{
		eval(callback);
	}
}

function printfire()
{
	if (document.createEvent)
	{
		printfire.args = arguments;
		var ev = document.createEvent("Events");
		ev.initEvent("printfire", false, true);
		dispatchEvent(ev);
	}
}