function makeRequest(url, callbackMethod) 
{
	if(window.XMLHttpRequest)
	{
		request = new XMLHttpRequest();
	}
	else if(window.ActiveXObject)
	{
		request = new ActiveXObject("Msxml2.XMLHTTP");
	}
	
	sendRequest(url, callbackMethod);
}

function sendRequest(url, callbackMethod)
{
	request.onreadystatechange = callbackMethod;
	request.open("GET", url, true);
	request.send(null);
} 

function checkReadyState(obj, id)
{
	switch(obj.readyState)
	{
		case 0:
			document.getElementById(id).innerHTML = "Trwa wysyanie dania...";
			break;
		case 1:
			document.getElementById(id).innerHTML = "Trwa wczytywanie odpowiedzi...";
			break;
		case 2:
			document.getElementById(id).innerHTML = "Odpowied wczytana...";
			break;
		case 3:
			document.getElementById(id).innerHTML = "Odpowied gotowa...";
			break;
		case 4:
			document.getElementById(id).innerHTML = "";
			return (obj.status == 200);
			break;
		default:
			document.getElementById(id).innerHTML = "Wystpi nieoczekiwany bd.";
	}
}

function onXMLResponse()
{
	if(checkReadyState(request, 'loading') == true)
	{
		var response = request.responseXML.documentElement;
		
		// Kategorie
		document.getElementById("body").innerHTML = "------------<br/>";
		document.getElementById("body").innerHTML += "<b>Categories</b><br/>";
		document.getElementById("body").innerHTML += "------------<br/>";
		
		var categories = response.getElementsByTagName('category');
		for(var i=0; i<categories.length; i++)
		{
			document.getElementById("body").innerHTML += response.getElementsByTagName('category')[i].firstChild.data +"</br>";
		}
		
		// Pozycje
		document.getElementById("body").innerHTML += "------------<br/>";
		document.getElementById("body").innerHTML += "<b>Items</b><br/>";
		document.getElementById("body").innerHTML += "------------<br/>";
		
		var row = response.getElementsByTagName('row');
		for(var i=0; i<row.length; i++)
		{
			var action = response.getElementsByTagName('items')[i].getAttribute('action');
			var icon = response.getElementsByTagName('items')[i].getAttribute('icon');
			
			document.getElementById("body").innerHTML += action +"<br/>"+ icon +"</br>";
			
			var items = response.getElementsByTagName('items')[i].childNodes;
			for(var j=0; j<items.length; j++)
			{
				for(var k=0; k<items[j].childNodes.length; k++)
				{
					document.getElementById("body").innerHTML += items[j].childNodes[k].nodeValue +"</br>";
				}
			}
			document.getElementById("body").innerHTML += "------------<br/>";
		}
	}
}

function onJSONResponse()
{
	if(checkReadyState(request, 'loading') == true)
	{
		eval("var response = ("+request.responseText+")");
		
		// Kategorie
		document.getElementById("body").innerHTML = "------------<br/>";
		document.getElementById("body").innerHTML += "<b>Categories</b><br/>";
		document.getElementById("body").innerHTML += "------------<br/>";
		
		for(var i in response.data.categories.category)
		{
			document.getElementById("body").innerHTML += response.data.categories.category[i] +"<br/>";
		}
		
		// Pozycje
		document.getElementById("body").innerHTML += "------------<br/>";
		document.getElementById("body").innerHTML += "<b>Items</b><br/>";
		document.getElementById("body").innerHTML += "------------<br/>";
		
		for(var i in response.data.row.items)
		{
			for(var j in response.data.row.items[i])
			{
				document.getElementById("body").innerHTML += response.data.row.items[i][j] +"<br/>";
			}
			document.getElementById("body").innerHTML += "------------<br/>";
		}
	}
}