// Przygotowanie elementw kontrolki accordion
aaManageEvent(window,"load", function() {
    var divs = document.getElementsByTagName('div');

    for (var i = 0; i < divs.length; i++) {

       // Konfigurowanie kliknicia paska tytuu
       if (divs[i].className == 'nameCollapsed') {
          aaManageEvent(divs[i],'click',Accordion.expandOrCollapse);

       // Przypisanie wysokoci jako waciwoci niestandardowej
       // i zwinicie elementu
       } else if (divs[i].className == 'elements') {
 
          // IE 6.x obsuguje elementy zwrcone przez funkcj getElementsByTagName
          // w inny sposb, dlatego clientHeight nie dziaa; w zamian 
          // uyto funkcji offsetHeight
          var height = divs[i].offsetHeight;
          divs[i].height = height;
          if (divs[i].id == "") divs[i].id = "div" + i;
          divs[i].style.height = "0";
      }
    }
});

// Zarzdzanie kontrolk accordion
var Accordion = { 

   // Dostosowanie wysokoci
   adjustItem  : function(val, newItem) {
            aaElem(newItem).style.height=val + "px";
   },

   // Sprawdzanie, czy panel naley rozwin, czy ukry
   expandOrCollapse : function (evnt) {
            evnt = evnt ? evnt : window.event;
            var target = evnt.target ? evnt.target : evnt.srcElement;
            if (target.className == 'nameCollapsed') 
                 Accordion.expand(target);
            else
                 Accordion.collapse(target);
   },

   // Rozwijanie panelu
   expand : function(target) {
            target.className = 'nameExpanded';
            // Zmiana sygnau
            var children = target.parentNode.childNodes;
            var panel;
            for (var i = 0; i < children.length; i++) {
              if (children[i].className == 'elements') {
                 panel = children[i];
                 break;
              }
            }
            var height = panel.height;

            // Obliczanie przyrostu poprzez podzielenie wysokoci przez
            // liczb iteracji ptli - 20
            var incr = height / 20;
            for (var i=0; i < 20; i++) {
              var val = (i+1) * incr;
              var func = "Accordion.adjustItem("+val+",'"+ panel.id +"')";
              setTimeout(func,(i+1)*30);
            }

   },
   
   // Zwijanie panelu
   collapse : function (target) {
            target.className = 'nameCollapsed';
            // Wyszukiwanie panelu
            var children = target.parentNode.childNodes;
            var panel;
            for (var i = 0; i < children.length; i++) {
              if (children[i].className == 'elements') {
                 panel = children[i];
                 break;
              }
            }
            var height = panel.height;

            // Obliczanie pomniejszenia poprzez podzielenie wysokoci przez
            // liczb iteracji ptli - 20
            var decr = height / 20;
            for (var i=0; i < 20; i++) {
              var val = height-(decr*(i+1));;
              var func = "Accordion.adjustItem("+val+",'"+ panel.id +"')";
              setTimeout(func,(i+1)*30);
            }
   }

 };


