function showPage() {
   getRows(this.identifier);
}

function getRows(start) {
   var url = 'getposts.php?start=' + start;
   var script = document.createElement('script');
   script.type = 'text/javascript';
   script.src = url + '&limit=20&callback=printRows';
   document.getElementsByTagName('head')[0].appendChild(script);
}

function createTableCell(value,tr) {

   // Tworzy element <td>
   var cell = document.createElement("td");

   // Tworzy wze tekstowy
   var text = document.createTextNode(value);

   // Docza wze tekstowy do komrki <td>
   cell.appendChild(text);

   // Docza komrk <td> do wiersza <tr>
   tr.appendChild(cell);

   return tr;
}

function printRows(rowsObj) {

   var main = aaElem('main');

   // Usuwanie dawnej zawartoci
   var oTable = aaElem('dataTable');
   if (oTable) main.removeChild(oTable);

   var table     = document.createElement("table");
   table.id = "dataTable";
   var tableBody = document.createElement("tbody");

   // Wiersze tabeli
   for(var i = 0; i < rowsObj.length; i++) {
        // Tworzy element <tr>
        var row = document.createElement("tr");

        row = createTableCell(rowsObj[i].id, row);

        // Znacznik adresu i tytu
        var cell = document.createElement("td");
        cell.innerHTML = "<a href='" + rowsObj[i].guid + "'>" + rowsObj[i].title + 
                         "</a>";
        row.appendChild(cell);

        row = createTableCell(rowsObj[i].comments,row);

        tableBody.appendChild(row);
   }

   table.appendChild(tableBody);
   aaElem('main').appendChild(table);

}

// Konfigurowanie aplikacji i wzw nawigacyjnych
aaManageEvent(window,'load',function() {

   var past;
   var home;
   for (var i = 0; i <= 10; i++) {
      var nav = Navigation.addNavigationNode(past,i*20,showPage);
      if (!past) {
        home = nav;
      }
      past = nav;
   }

   // Ustawianie stron
   Navigation.setHome(home);
   Navigation.setCurrentPage(home);

  aaManageEvent(aaElem('next'),'click',aaBindObjMethod(Navigation,Navigation.nextPage));
  aaManageEvent(aaElem('previous'),'click',aaBindObjMethod(Navigation,Navigation. 
  prevPage));
  aaManageEvent(aaElem('home'),'click', Navigation.returnHome);
});



