// przestrzeń nazw SVG
var svgNS = "http://www.w3.org/2000/svg";
// zmienna obsługi dokumentu SVG
var documentSVG = null;
// przechowa główny element <g>, który grupuje wszystkie składniki wykresu
var chartGroup = null;
// jak często żądać nowych danych z serwera
var updateInterval = 1000; 
// współrzędne przesunięcia wykresu (w pikselach)
var x = 50, y = 50;
// wymiary wykresu (w pikselach) 
var height = 300, width = 500;
// początek osi wykresu 
var xt1 = 0, yt1 = 0;
// wartości maksymalne na osiach
var xt2 = 50, yt2 = 100;
// liczba podziałek na obu osiach
var xDivisions = 10, yDivisions = 10;
// domyślne wartości wysokości i szerokości początkowo wyświetlanego tekstu (później jeszcze przeliczane)
var defaultTextWidth = 30, defaultTextHeight = 20; 
// zatrzyma odwołania do jednostek osi wykresu w celu ich późniejszego przeliczenia
var xIndexes = new Array(xDivisions + 1);
var yIndexes = new Array(yDivisions + 1);
// przechowa tekst, który zostanie wyświetkony nad wybranym punktem wykresu
var currentNodeInfo;
// zatrzymuje ostatnie wartości współrzędnych wygenerowane przez serwer
var lastX = -1, lastY = -1;
// współdzielone elementy svg 
var chartGroup, dataGroup, dataPath;

 
// inicjalizacja wykresu 
function init(evt) 
{
  /**** Przygotowanie grupy, która przechowa wszystkie dane wykresu  ****/
    // przypisanie wartości do zmiennej obsługi dokumentu 
  documentSVG = evt.target.ownerDocument;
  // stworzenie elementu <g>, który zgrupuje wszystkie składniki wykresu 
  chartGroup = documentSVG.createElementNS(svgNS, "g");
  chartGroup.setAttribute("transform", "translate(" + x + " " + y + ")");
  
  /**** Przygotowanie grupy, która przchowa osie X i Y i liczby ****/
  axisGroup = documentSVG.createElementNS(svgNS, "g");
  // tworzy oś X jako element <path>
  axisPath = documentSVG.createElementNS(svgNS, "path");
  // ustawia grubość osi na 2 piksele i kolor na czarny
  axisPath.setAttribute("stroke", "black"); 
  axisPath.setAttribute("stroke-width", "2");

  /**** Tworzy podziałkę na osiach X i Y  ****/  
  // tworzy tekst opisujący dla podziałek na osi X
  pathText = "M 0 " + height; 
  // dodaje podział do osi X (inny niż poprzedni podział)
  for (var i = 0; i <= xDivisions; i++)
    pathText += "l 0 5 l 0 -5 " +
      ((i == xDivisions) ? "" : ("l " + width/xDivisions + " 0"));
  // tworzy tekst opisujący dla podziałek na osi Y
  pathText += "M 0 " + height;
  // dodaje podział do osi Y (inaczej niż przy poprzednim podziale)
  for (var i = 0; i <= yDivisions; i++)
    pathText += "l -5 0 l 5 0 " + 
     ((i == yDivisions) ? "" : ("l 0 -" + height / yDivisions)); 
  // dodaje definicję atrybutu <d> do polecenia path
  axisPath.setAttribute("d", pathText); 
  // dodaje path do grupy elementów osi
  axisGroup.appendChild(axisPath);

  /**** Tworzy tekst przy podziałkach osi X i Y  ****/
  // dodaje węzły tekstowe do osi X
  for (var i = 0; i <= xDivisions; i++)   
  {
    // tworzy węzeł <text> dla podziału
    t = documentSVG.createElementNS(svgNS, "text");
    // przechowuje węzeł dla późniejszych odwołań
    xIndexes[i] = t;
    // tworzy zawartość tekstową węzła <text>
    t.appendChild(documentSVG.createTextNode(
     (xt1 + i * ((xt2 - xt1) / xDivisions)).toFixed(1)));
    // ustala atrybuty X i Y dla węzła <text> 
    t.setAttribute("x", i * width / xDivisions - defaultTextWidth / 2);
    t.setAttribute("y", height + 30 + defaultTextHeight); 
    // chcemy, by podczas pierwszego ładowania wykresu tekst pozostał niewidoczny
    t.setAttribute("stroke", "white"); 
    // dodaje węzeł <text> do grupy osi
    axisGroup.appendChild(t);
  }
  // dodaje węzły tekstowe do osi Y
  for (var i = 0; i <= yDivisions; i++)
  {
    // tworzy węzeł <text> dla podziału
    t = documentSVG.createElementNS(svgNS, "text");
    // przechowuje węzeł dla późniejszych odwołań
    yIndexes[i] = t;
    // tworzy zawartość tekstową węzła <text>
    t.appendChild(documentSVG.createTextNode(
     (yt1 + i * ((yt2 - yt1) / yDivisions)).toFixed(1))); 
 
    // ustala atrybuty X i Y dla węzła <text>
    t.setAttribute("x", -30 -defaultTextWidth);
    t.setAttribute("y", height - i * height / yDivisions + defaultTextHeight / 2); 
    // chcemy, by podczas pierwszego ładowania wykresu tekst pozostał niewidoczny
    t.setAttribute("stroke", "white");  
    // dodaje węzeł <text> do grupy osi
    axisGroup.appendChild(t);
  }
  
  // dodaje grupę osi do grupy  wykresu
  chartGroup.appendChild(axisGroup);

  /**** Przygotowanie elementu <path>, który narysuje dane na wykresie ****/ 
  dataPath = documentSVG.createElementNS(svgNS, "path"); 
  dataPath.setAttribute("stroke", "black");
  dataPath.setAttribute("stroke-width", "1");
  dataPath.setAttribute("fill", "none");
  // dodaje dane elementu path do grupy wykresu 
  chartGroup.appendChild(dataPath);
  
  /**** Ostatnie kroki prowadzące do inicjalizacji ****/
  // dodaje grupę wykresu do dokumentu SVG
  documentSVG.documentElement.appendChild(chartGroup);
  // polecenie niezbędę do poprawnego wyświetlenia węzłów tekstu w przeglądarce Firefox
  setTimeout("refreshXYIndexes()", 500);
  // inicjalizacja powtarzających się żądań wysyłanych do serwera
  setTimeout("updateChart()", updateInterval);
}

// ta funkcja przerysowuje jednostki osi i sprawia, że stają się one widoczne
// (to działanie jest niezbędne dla poprawnego pozycjonowania tekstu w przeglądarce Firefox)
function refreshXYIndexes()
{
  // rysuje ponownie węzły tekstowe na osi X
  for (var i = 0; i <= xDivisions; i++)
    if (typeof xIndexes[i].getBBox != "undefined")
      try 
      {
        textWidth = xIndexes[i].getBBox().width;
        textHeight = xIndexes[i].getBBox().height;
        xIndexes[i].setAttribute("x", i*width/xDivisions - textWidth/2);
        xIndexes[i].setAttribute("y", height + 10 + textHeight);
        xIndexes[i].setAttribute("stroke", "black");
      } 
      catch(e) {}
  // rysuje ponownie węzły tekstowe na osi Y
  for (var i = 0; i <= yDivisions; i++)
    if (typeof yIndexes[i].getBBox != "undefined") 
      try 
      {
        twidth = yIndexes[i].getBBox().width;
        theight = yIndexes[i].getBBox().height;
        yIndexes[i].setAttribute("y", height-i*height/yDivisions
                                                          +theight/2);
        yIndexes[i].setAttribute("x", -10 -twidth);
        yIndexes[i].setAttribute("stroke", "black");
      } 
      catch(e) {} 
}

 
// funkcja wywoływana, kiedy kursor myszy znajdzie się nad punktem na wykresie — wyświetli współrzędne punku
function createPointInfo(x, y, whereX, whereY) 
{
  // daje gwarancję, że nie wyświetlisz więcej niż jednej pary współrzędnych na raz
  if (currentNodeInfo) removePointInfo();
  // tworzy węzeł tekstowy
  currentNodeInfo = documentSVG.createElementNS(svgNS, "text");
  currentNodeInfo.appendChild(documentSVG.createTextNode("("+x+","+y+")"));
  // ustawia współrzędne
  currentNodeInfo.setAttribute("x", whereX.toFixed(1));
  currentNodeInfo.setAttribute("y", whereY - 10);
  // dodaje węzeł do grupy
  chartGroup.appendChild(currentNodeInfo);
}
  
//usuwa węzeł tkstowy, który wyświetla współrzędne na wykresie
function removePointInfo()
{
  chartGroup.removeChild(currentNodeInfo);
  currentNodeInfo = null;
}
  
//rysuje nowy punkt na wykresie
function addPoint(X, Y) 
{
  //zachowuje współrzędne tego punktu dla późniejszych odwołań
  lastX = X;
  lastY = Y;
  // przeładowuje stronę po wygenerowaniu ostatnich wartości
  if (X == xt2)
    window.location.reload(false);
  //oblicza współrzędne nowego punktu
  coordX = (X - xt1) * (width / (xt2 - xt1));  
  coordY = height - (Y - yt1) * (height / (yt2 - yt1));
  //rusyje nowy punkt na wykresie w postaci niebieskiego kółka
  var circle = documentSVG.createElementNS(svgNS, "circle"); 
  circle.setAttribute("cx", coordX); // współrzędna X
  circle.setAttribute("cy", coordY); // współrzędna Y
  circle.setAttribute("r", 3); // promień
  circle.setAttribute("fill", "blue"); // kolor
  circle.setAttribute("onmouseover",
    "createPointInfo(" + X + "," + Y + "," + coordX + "," + coordY + ")");
  circle.setAttribute("onmouseout", "removePointInfo()");
  chartGroup.appendChild(circle);
  // dodaje linię do nowego punktu na wykresie
  current = dataPath.getAttribute("d"); // bieżąca definicja ścieżki
  // aktualizuje definicję ścieżki
  if (!current || current == "")
    dataPath.setAttribute("d", " M " + coordX + " " + coordY);  
  else
    dataPath.setAttribute("d", current + " L " + coordX + " " + coordY);
}

// inicjuje asynchroniczne żądanie uzyskania nowych danych do wykresu
function updateChart()
{
  // tworzy łańcuch zapytania
  param = "?lastX=" + lastX + ((lastY != -1) ? "&lastY=" + lastY : "");
  // wykonuje żądanie technologii  AJAX
  if (window.getURL)
    // wspieranej przez SVG Adobe'a i Apache Batik
    getURL("svg_chart.php" + param, handleResults);
  else
 
    // wspieranej przez Mozillę, zaimplementowają w pliku ajaxRequest.js
    ajaxRequest("svg_chart.php" + param, handleResults);
}

// funkcja zwrotna, która pobiera dane przesłane z serwera   
function handleResults(data) 
{
  // pobiera dane z odpowiedzi
  if (window.getURL)
    responseText = data.content;
  else
    responseText = data; 
  // dzieli parę, by uzyskać współrzędne X i Y
  var newCoords = responseText.split(",");
  // rysuje nowy punkt w oparciu o te współrzędne
  addPoint(newCoords[0], newCoords[1]);  
  // powtarza sekwencję
  setTimeout("updateChart()", updateInterval)
}

