<?php
// uruchamia obsługę błędów i połączenie z bazą danych
require_once ('error_handler.php');
require_once ('config.php');
// klasa tworzy listę zadań i wykonuje działania dodaj/usuń/zmień kolejność
class TasksList
{
  // służy do przechowania połączenia z bazą danych
  private $mMysqli;
  // konstruktor, otwiera połączenie z bazą
  function __construct() 
  {   
    // łączy się z bazą
    $this->mMysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_DATABASE); 
  }
  // destruktor, zamyka połączenie z bazą
  public function __destruct() 
  {
    $this->mMysqli->close();
  }
  // buduje listę zadań
  public function BuildTasksList()
  {
    // inicjuje dane wyjściowe
    $myList = '';
    // tworzy zapytanie
    $result = $this->mMysqli->query('SELECT * FROM tasks ' . 'ORDER BY order_no ASC');
    // tworzy listę zadań w postaci elementów <li>
    while ($row = $result->fetch_assoc()) 
    { 
      $myList .= '<li id="' . htmlentities($row['id']) . '">' . 
        htmlentities($row['description']) . '</li>';
    }
    // zwraca listę
    return $myList;
  }

  // obsługuje zadania po stronie serwera
  public function Process($content, $action)
  {
    // podejmuje działania określone przez klienta
    switch($action)
    {
      // zmienia kolejność elementów listy zadań
      case 'updateList':
        // pobiera szczegóły aktualizacji
        $new_order = explode('_', $content);
        // aktualizacja listy
        for ($i=0; $i < count($new_order); $i++)
        {
          // dane pobrane od klienta
          $new_order[$i] = $this->mMysqli->real_escape_string($new_order[$i]);
          // zadanie aktualizacji
          $result = $this->mMysqli->query('UPDATE tasks SET order_no="' .
            $i . '" WHERE id="' . $new_order[$i] . '"');
        }
        $updatedList = $this->BuildTasksList();
        return $updatedList;
        break;
      // dodaje nowe zadanie
      case 'addNewTask':
        // dane wejściowe
        $task = trim($this->mMysqli->real_escape_string($content));
        // kontynuuje, jeżeli nazwa nie jest pusta
        if ($task)
        {
          // pobiera najwyższy kolejny numer
          $result = $this->mMysqli->query('SELECT (MAX(order_no) + 1) ' .
            'AS order_no FROM tasks');
          $row = $result->fetch_assoc();
          // jeśli tabela jest pusta, to nada numer zerowy
          $order = $row['order_no'];          
          if (!$order) $order = 1;
          // wstaw nowe zadanie na dole listy
          $result = $this->mMysqli->query
            ('INSERT INTO tasks (order_no, description) ' .
             'VALUES ("' . $order . '", "' . $task . '")');
          // zwraca aktualną listę zadań
          $updatedList = $this->BuildTasksList();
          return $updatedList;
        }
        break;
      // Usuń zadanie
      case 'delTask':
        // dane wejściowe
        $content = trim($this->mMysqli->real_escape_string($content));
        // usuwa zadanie
        $result = $this->mMysqli->query('DELETE FROM tasks WHERE id="' .
          $content . '"');
        $updatedList = $this->BuildTasksList();
        return $updatedList;
        break;
    }
  }
}
?>