<?php
// uruchamia moduł obsługi błędów i klasę Grid
require_once('error_handler.php');
require_once('grid.class.php');
// wartością parametru 'action' powinno być FEED_GRID_PAGE lub UPDATE_ROW 
if (!isset($_GET['action']))
{  
  echo 'Błąd serwera: brak polecenia od klienta.';
  exit;
}      
else 
{
  // przechowuje wartość parametru określającego czynności, które należy podjąć
  $action = $_GET['action'];
}
// tworzy instancję klasy Grid
$grid = new Grid($action);
// sprawdza poprawność wartości parametru action
if ($action == 'FEED_GRID_PAGE')
{
  // pobiera numer strony
  $page = $_GET['page'];
  // czyta produkty na stronie
  $grid->readPage($page);
}
else if ($action == 'UPDATE_ROW')
{
  // pobiera parametry
  $id = $_GET['id'];
  $on_promotion = $_GET['on_promotion'];
  $price = $_GET['price'];
  $name = $_GET['name'];
  // aktualizuje rekord
  $grid->updateRecord($id, $on_promotion, $price, $name);
}
else 
  echo 'Server error: client command unrecognized.';
// czyści dane wyjściowe
if(ob_get_length()) ob_clean();
// nagłówki mają zapobiec zapisaniu danych w pamięci przeglądarki
header('Expires: Fri, 25 Dec 1980 00:00:00 GMT'); // czas w przeszłości
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . 'GMT'); 
header('Cache-Control: no-cache, must-revalidate'); 
header('Pragma: no-cache');
header('Content-Type: text/xml');
// tworzy dane wyjściowe w formacie XML
header('Content-type: text/xml'); 
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<data>';
echo '<action>' . $action . '</action>';
echo $grid->getParamsXML();
echo $grid->getGridXML();
echo '</data>';
?>