// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// przechowuje adres i parametry zdalnego serwera
var serverAddress = "smartproxyping.php";
var getNumberParams = "action=GetNumber" + // pobiera nową liczbę losową
  "&min=1" + // liczba minimalna
  "&max=100"; // liczba maksymalna
var checkAvailabilityParams = "action=CheckAvailability"; 
// zmienne pozwalające określić dostępność serwera
var requestsCounter = 0; // zlicza ile liczb zostało pobranych
var checkInterval = 10; // oblicza interwał do sprawdzenia dostępności serwera
var updateInterval = 1; // ile sekund czekać na pobranie nowej liczby
var updateIntervalIfServerBusy = 10; // ile sekund czekać, jeśli serwer jest zajęty
var minServerBufferLevel = 50; // akceptowalny poziom zapełnienia bufora

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż któryś zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca stworzony obiekt albo wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// asynchroniczne wywołanie serwera
function process()
{
 
  // kontynuuje, jeśli xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // jeśli dopiero zaczyna lub osiągnął określoną liczbę żądań,
      // sprawdza dostępność serwera; w przeciwnym razie żąda nowej liczby losowej
      if (requestsCounter % checkInterval == 0) 
      {
        // sprawdza czy serwer jest dostępny
        xmlHttp.open("GET", serverAddress + "?" + checkAvailabilityParams, true);
        xmlHttp.onreadystatechange = handleCheckingAvailability;
        xmlHttp.send(null);
      }
      else
      {
        // pobiera liczbę losową
        xmlHttp.open("GET", serverAddress + "?" + getNumberParams, true);
        xmlHttp.onreadystatechange = handleGettingNumber;
        xmlHttp.send(null);
      }
    }
    catch(e)
    {
      alert("Nie można nawiązać połączenia z serwerem:\n" + e.toString());
    }
  }
}
// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleCheckingAvailability() 
{
  // kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z serwera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        checkAvailability();
      }
      catch(e)
      {
        // wyświetla komunikat o błędzie
        alert("Błąd odczytu dostępności serwera:\n" + e.toString());
      }
    } 
    else
    {
      // wyświetla komunikat o statusie
      alert("Błąd podczas sprawdzania dostępności serwera:\n" + xmlHttp.statusText);
    }
  }
}

// obsługuje odpowiedź otrzymaną z serwera
function checkAvailability()
{
  // odbiera odpowiedź serwera
  var response = xmlHttp.responseText;
 
  // jeśli odpowiedź jest odpowiedni długa, lub pusta, zakładamy, że otrzymaliśmy raport o błędzie
  if(response.length > 5 || response.length == 0)
    throw(response.length == 0 ? "Bład serwera" : response);
  // pobiera odwołanie do elementu <div> na stronie
  myDiv = document.getElementById("myDivElement");
  // wyświetla odpowiedź jako HTML
  if (response >= minServerBufferLevel)
  {
    // wyświetla nowy komunikat dla użytkownika
    myDiv.innerHTML += "Poziom bufora serwera to " + response + "%, "
                     + "pobieram nowe liczby. <br/>";
    // zwiększ licznik, aby rozpocząć pobieranie liczb losowych
    requestsCounter++;       
    // powtarza sekwencję
    setTimeout("process();", updateInterval * 1000);            
  }
  else
  {
    // wyświetla nowy komunikat dla użytkownika
    myDiv.innerHTML += "Poziom bufora serwera jest zbyt niski (" + response + "%), "
      + "spróbuję ponownie za " + updateIntervalIfServerBusy + " sekund. <br/>";
    // powtarza sekwencję
    setTimeout("process();", updateIntervalIfServerBusy * 1000);            
  }
}
// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleGettingNumber() 
{
  // kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z serwera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        getNumber();
      }
      catch(e)
      {
        // komunikat o błędzie
        alert("Błąd podczas pobierania liczby z serwera:\n" + e.toString());
      }
    } 
    else
    {
      // wyświetla komunikat o statusie
      alert("Błąd podczas odbioru nowej liczby:\n" + xmlHttp.statusText);
    }
  }
}

// obsługuje odpowiedź z serwera
function getNumber()
{
  // odbiera odpowiedź serwera
  var response = xmlHttp.responseText;
  // jeśli odpowiedź jest odpowiedni długa, lub pusta, zakładamy, że otrzymaliśmy raport o błędzie
  if(response.length > 5 || response.length == 0)
    throw(response.length == 0 ? "Server error" : response);
  // pobiera odwołanie do elementu <div> na stronie
  myDiv = document.getElementById("myDivElement");
  // wyświetla wynik w postaci HTML
  myDiv.innerHTML += "Nowa liczba losowa z serwera to: " + response + "<br/>";
  // zwiększa licznik żądań
  requestsCounter++;
  // ponawia sekwencję
  setTimeout("process();", updateInterval * 1000);
}

