// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje utworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // w przypadku, gdy przeglądarką jest IE6 lub starszy
    var XmlHttpVersions = new Array('MSXML2.XMLHTTP.6.0',
      'MSXML2.XMLHTTP.5.0',
      'MSXML2.XMLHTTP.4.0',
      'MSXML2.XMLHTTP.3.0',
      'MSXML2.XMLHTTP',
      'Microsoft.XMLHTTP');
    // sprawdza każdy identyfikator programu, aż jeden zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
 
      { 
        // próbuje utworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// wywołana do odczytania pliku z serwera
function process()
{
  // kontynuuje tylko jeśli obiekt xmlHttp istnieje
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // inicjalizacja odczytu pliku async.txt z serwera
      xmlHttp.open("GET", "books.xml", true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
    }
    // w przypadku niepowodzenia wyświetla komunikat o błędzie
    catch (e)
    {
      alert("Nie mogę połączyć się z serwerem:\n" + e.toString());
    }
  }
}

// funkcja wywoływana przy zmianie statusu HTTP
function handleRequestStateChange() 
{
  // kiedy readyState ma wartość 4, zaczynamy odczyt odpowiedzi serwera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status serwera ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // obsługuje odpowiedź z serwera
        handleServerResponse();
      }
      catch(e)
      {
        // wyświetla komunikat o błędzie
        alert("Błąd odczytu odpowiedzi: " + e.toString());
      }
    } 
    else
    {
      // wyświetla statut wiadomości
      alert("Pojawił się problem w uzyskaniu danych:\n" +
        xmlHttp.statusText);
    }
  }
}

 
// obsługuje odpowiedź otrzymaną z serwera
function handleServerResponse()
{
  // odczyt wiadomości z serwera
  var xmlResponse = xmlHttp.responseXML;
  // pobranie obiektu dokumentu pliku XML
  xmlRoot = xmlResponse.documentElement;  
  // pobranie tablic z tytułami książek i numerami ISBN
  titleArray = xmlRoot.getElementsByTagName("title");
  isbnArray = xmlRoot.getElementsByTagName("isbn");
  // wygenerowanie danych wyjściowych w postaci pliku HTML
  var html = "";  
  // iteracyjne przejście przez tablice i tworzenie struktury HTML
  for (var i=0; i<titleArray.length; i++)
    html += titleArray.item(i).firstChild.data + 
            ", " + isbnArray.item(i).firstChild.data + "<br/>";
  // pobranie referencji do elementu <div> na stronie
  myDiv = document.getElementById("myDivElement");
  // wyświetlenie danych wyjściowych w postaci pliku HTML
  myDiv.innerHTML = "Serwer mówi: <br />" + html;
}

