// przechowuje instancję obiektu XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// kiedy parametr ma wartość true, wyświetla szczegółowy komunikat o błędzie
var showErrors = true;
// zakłada pamięć podręczną żądania
var cache = new Array();
// tworzy instancję obiektu XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  //  powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 lub starszych
  try
  {
    // próbuje utworzyć obiekt  XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
                                    "MSXML2.XMLHTTP.5.0",
                                    "MSXML2.XMLHTTP.4.0",
                                    "MSXML2.XMLHTTP.3.0",
                                    "MSXML2.XMLHTTP",
                                    "Microsoft.XMLHTTP");
    //  sprawdza każdy prog id aż jeden zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {} // ignoruje potencjalne błędy
    }
  }
  // zwraca utworzony obiekt lub wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}
// funkcja wyświetlająca komunikat o błędzie
function displayError($message)
{
  // ignoruje błędy, jeśli parametr showErrors ma wartość false
  if (showErrors)
  {
    // wyłącza wyświetlanie szczegółów błędu
    showErrors = false;
    // wyświetla komunikat o błędzie
    alert("Wystąpił błąd: \n" + $message);
 
  }
}
// Scriptaculous-specjalny kod, pozwalający zdefiniować listę z możliwością sortowania i funkcją "przeciągnij i upuść"
function startup()
{
  // przekształca nieuporządkowaną listę w listę posortowaną z elementami, które można przeciągać
  Sortable.create("tasksList", {tag:"li"}); 

  // definiuje obszar, w którym można upuścić element do usunięcia
  Droppables.add("trash", 
  {
    onDrop: function(element) 
    {
      var deleteTask = confirm("Jesteś pewnien, że chcesz usunąć to zadanie?")
      if (deleteTask)
      {
        Element.hide(element);
        process(element.id, "delTask");
      }
    }
  });
}
// nadaje kolejne numery id kolejnym elementom listy (<li>)
function serialize(listID)
{
  // zlicza ilość elementów listy
  var length = document.getElementById(listID).childNodes.length;
  var serialized = "";
  // przegląda w pętli wszystkie elementy
  for (i = 0; i < length; i++)
  {
    // pobiera bieżący element
    var li = document.getElementById(listID).childNodes[i];
    // pobiera identyfikator obecnego elementu bez jego części tekstowej
    var id = li.getAttribute("id");
    // dołącza sam numer do tablicy identyfikatorów
    serialized += encodeURIComponent(id) + "_";
  }
  // zwraca tablicę, odcinając '_'
  return serialized.substring(0, serialized.length - 1);
}
// wysyła żądanie na serwer
function process(content, action)
{
  // kontynuuje jedynie jeśli obiekt xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // rozpoczyna zapytanie żądania z pustym zapytaniem
    params = "";
    // zamienia znaki specjalne, aby bezpiecznie przekazać wartość do serwera
    content = encodeURIComponent(content);
    // wysyła parametr w zależności od podjętego działania
    if (action == "updateList")
      params = "?content=" + serialize(content) + "&action=updateList";
    else if (action == "addNewTask")
    {
      // przygotowuje zadanie do wysyłki na serwer
      var newTask = trim(encodeURIComponent(document.getElementById(content).value));
      // nie dodaje pustych zadań
      if (newTask)
        params = "?content=" + newTask + "&action=addNewTask";
    }
    else if (action =="delTask")
      params = "?content=" + content + "&action=delTask";
    // nie dodaje zerowych parametrów do pamięci
    if (params) cache.push(params);
    // próbuje połączyć się z serwerem
    try
    {
      // kontynuuje jedynie, jeśli połączenie jest wolne, a pamięć nie jest pusta
      if ((xmlHttp.readyState == 4 || xmlHttp.readyState == 0)
           && cache.length>0)
      {
        // pobiera kolejny zestaw wartości z pamięci
        var cacheEntry = cache.shift();
        // rozpoczyna żądanie
        xmlHttp.open("GET", "drag-and-drop.php" + cacheEntry, true);
        xmlHttp.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xmlHttp.onreadystatechange = handleRequestStateChange;
        xmlHttp.send(null);
      }
      else
      {
        setTimeout("process();", 1000);  
      }
    }
    // w razie porażki, wyświetla komunikat o błędzie
    catch (e)
    {
      displayError(e.toString());
    }
  }
}
// funkcja, która pobiera odpowiedź HTTP
function handleRequestStateChange() 
{
  //  kiedy readyState ma wartość 4, odczytujemy odpowiedź serwera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje, jeśli status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        postUpdateProcess();
      }
      catch(e)
      {
        // wyświetla komunikat o błędzie
        displayError(e.toString());
      }
    } 
    else 
    {
      displayError(xmlHttp.statusText);
    }
  }
}
// przetwarza odpowiedź serwera
function postUpdateProcess()
{
  // czyta odpowiedź serwera
  var response = xmlHttp.responseText;
  // błąd serwera?
  if (response.indexOf("ERRNO") >= 0 || response.indexOf("error") >= 0)
    alert(response);
  // aktualizuje listę zadań
  document.getElementById("tasksList").innerHTML = response;
  Sortable.create("tasksList");
  document.getElementById("txtNewTask").value = "";
  document.getElementById("txtNewTask").focus(); 
} 
/* obsługuje zdarzenie keydown, czyli sprawdza, czy wciśnięto Enter */
function handleKey(e) 
{
  // pobiera zdarzenie
  e = (!e) ? window.event : e;
  // pobiera kod znaku, który został wciśnięty
  code = (e.charCode) ? e.charCode :
         ((e.keyCode) ? e.keyCode :
         ((e.which) ? e.which : 0));
  // obsługa zdarzenia keydown
  if (e.type == "keydown") 
  {
    // jeśli wciśnięto Enter (kod 13)
    if(code == 13)
    {
      // wysyła wiadomość
      process("txtNewTask", "addNewTask");
    }
  }
}
/* usuwa początkowe i końcowe spacje z łańcucha */
function trim(s)
{
  return s.replace(/(^\s+)|(\s+$)/g, "")
}

