// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();
// przechowuje adres i parametry zdalnego serwera
var serverAddress = "http://www.random.org/cgi-bin/randnum";
var serverParams = "num=1" + // ilość liczb losowych do wygenerowania
  "&min=1" + // liczba minimalna
  "&max=100"; // liczba maksymalna

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
 
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż któryś zadziała
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca stworzony obiekt albo wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// asynchroniczne wywołanie serwera
function process()
{
  // kontynuuje, jeśli xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // prosi o połączenie ze zdalnym serwerem przeglądarki oparte o Mozillę
      try
      {
       // generuje błąd (który jest ignorowany) jeśli przeglądarka nie jest Mozillą
       netscape.security.PrivilegeManager.enablePrivilege('UniversalBrowserRead');
      }
      catch(e) {} // ignoruje błąd
      // rozpoczyna dostęp do serwera
      xmlHttp.open("GET", serverAddress + "?" + serverParams, true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
    }
    // w razie niepowodzenia wyświetla komunikat o błędzie
    catch (e)
    {
      alert("Nie mogę nawiązać połączenia z sewerem:\n" + e.toString());
    }
  }
}

// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleRequestStateChange() 
{
  //  kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z serwera
  if (xmlHttp.readyState == 4) 
  {
 
    // kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        handleServerResponse();
      }
      catch(e)
      {
        // komunikat o błędzie
        alert("Wystąpił błąd podczas odczytu odpowiedzi: " + e.toString());
      }
    } 
    else
    {
      // wyświetla komunikat o statusie
      alert("Pojawił się problem podczas odbierania danych:\n" +
        xmlHttp.statusText);
    }
  }
}

// obsługuje odpowiedź otrzymaną z serwera
function handleServerResponse()
{
  // odbiera odpowiedź serwera
  var response = xmlHttp.responseText;
  // pobiera odwołanie do elementu <div> na stronie
  myDiv = document.getElementById('myDivElement');
  // wyświetla rezultat jako HTML
  myDiv.innerHTML = "Nowa liczba losowa odebrana z serwera: "
    + response + "<br/>";
}

