// przechowuje obiekt XMLHttpRequest
var xmlHttp = createXmlHttpRequestObject();

// tworzy obiekt XMLHttpRequest
function createXmlHttpRequestObject() 
{
  // przechowa odwołanie do obiektu XMLHttpRequest
  var xmlHttp;
  // powinno działać dla wszystkich przeglądarek z wyjątkiem IE6 i starszych
  try
  {
    // próbuje stworzyć obiekt XMLHttpRequest
    xmlHttp = new XMLHttpRequest();
  }
  catch(e)
  {
    // zakładając, że IE6 lub starsza
    var XmlHttpVersions = new Array("MSXML2.XMLHTTP.6.0",
      "MSXML2.XMLHTTP.5.0",
      "MSXML2.XMLHTTP.4.0",
      "MSXML2.XMLHTTP.3.0",
      "MSXML2.XMLHTTP",
      "Microsoft.XMLHTTP");
    // sprawdza każdy prog id aż któryś zadziała
 
    for (var i=0; i<XmlHttpVersions.length && !xmlHttp; i++) 
    {
      try 
      { 
        // próbuje stworzyć obiekt XMLHttpRequest
        xmlHttp = new ActiveXObject(XmlHttpVersions[i]);
      } 
      catch (e) {}
    }
  }
  // zwraca stworzony obiekt albo wyświetla komunikat o błędzie
  if (!xmlHttp)
    alert("Błąd podczas tworzenia obiektu XMLHttpRequest.");
  else 
    return xmlHttp;
}

// czyta plik z serwera
function process()
{
  // kontynuuje, jeśli obiekt xmlHttp nie jest pusty
  if (xmlHttp)
  {
    // próbuje połączyć się z serwerem
    try
    {
      // początkuje odczyt pliku z serwera
      xmlHttp.open("GET", "phptest.php", true);
      xmlHttp.onreadystatechange = handleRequestStateChange;
      xmlHttp.send(null);
    }
    // w razie niepowodzenia wyświetla komunikat o błędzie
    catch (e)
    {
      alert("Nie mogę połączyć się z serwerem:\n" + e.toString());
    }
  }
}


// funkcja wywoływana przy zmianie statusu żądania HTTP
function handleRequestStateChange() 
{
  // kiedy readyState ma wartość 4, jesteśmy gotowi do odebrania odpowiedzi z serwera
  if (xmlHttp.readyState == 4) 
  {
    // kontynuuje tylko, gdy status HTTP ma wartość "OK"
    if (xmlHttp.status == 200) 
    {
      try
      {
        // przetwarza wiadomość z serwera
        handleServerResponse();
      }
      catch(e)
      {
        // komunikat o błędzie
        alert("Error reading the response: " + e.toString());
      }
    } 
    else
    {
      // wyświetla wiadomość o statusie
      alert("Problem przy pobieraniu danych:\n" + xmlHttp.statusText);
    }
  }
}

// obsługuje odpowiedź otrzymaną z serwera
function handleServerResponse()
{
  // pobiera odpowiedź serwera
  var xmlResponse = xmlHttp.responseXML;
  // wyłapywanie potencjalnych błędów przez IE i Operę
  if (!xmlResponse || !xmlResponse.documentElement)
    throw("Niepoprawna struktura XML:\n" + xmlHttp.responseText);
  // wyłapywanie potencjalnych błędów przez Firefox
  var rootNodeName = xmlResponse.documentElement.nodeName;
  if (rootNodeName == "parsererror") throw("Niepoprawna struktura XML");
  // pobiera element document pliku XML
  xmlRoot = xmlResponse.documentElement;  
  // pobiera tablice tytułów i numerów ISBN
  titleArray = xmlRoot.getElementsByTagName("title");
  isbnArray = xmlRoot.getElementsByTagName("isbn");
  // generuje dane wyjściowe w formacie HTML
  var html = "";  
  // iteracja przez elementy tablic i tworzenie struktury HTML
  for (var i=0; i<titleArray.length; i++)
    html += titleArray.item(i).firstChild.data + 
      ", " + isbnArray.item(i).firstChild.data + "<br/>";
  // pobiera element <div> ze strony
  myDiv = document.getElementById("myDivElement");
  // wyświetla dane wyjściowe w formacie HTML
  myDiv.innerHTML = html;
}

