// Przechowuje referencję do obiektu XMLHttpRequest
var request = makeHTR(); 

// Pobiera obiekt XMLHttpRequest
function makeHTR() 
{  
   // Przechowa referencję do obiektu XMLHttpRequest
   var request;
   // Jeśli pracuje się w przeglądarce Mozilla bądź innych
   if(window.XMLHttpRequest)
   {
      try
      {
         request = new XMLHttpRequest();
      }
      catch (e) 
      {
         request = null;
      }
   }
   // Jeśli pracuje się w przeglądarce Internet Explorer
   else
   {
      try 
      {
         request = new ActiveXObject("Microsoft.XMLHTTP");
      }
      catch (e) 
      {
         request = null;
      }
   }
   // Zwrócenie utworzonego obiektu bądź wyświetlenie komunikatu o błędzie
   if (!request)
   { 
      alert("Przy tworzeniu obiektu XMLHttpRequest wystąpił błąd.");
   }  
   else 
   {
      return request;
   }
}

// Wykonanie asynchronicznego żądania HTTP za pomocą obiektu XMLHttpRequest
function sendRequest()
{  
   // Przejście dalej tylko wtedy, gdy obiekt xmlHttp nie jest zajęty
   if (request.readyState == 4 || request.readyState == 0)
   {
      // Dodanie zmiennej, która się zmienia, w celu obejścia problemów z umieszczaniem stron w pamięci podręcznej w przeglądarce Internet Explorer
      num = Math.round(Math.random()*999999);
   
      request.open("GET", "FeedRead3.php?id="+num, true);  
      // Zdefiniowanie metody obsługującej odpowiedzi z serwera
      request.onreadystatechange = processResults;
      // Przesłanie żądania do serwera
      request.send(null);
   }
   else
   {   
      // Jeśli połączenie jest zajęte, należy spróbować ponownie za sekundę  
      setTimeout('sendRequest()', 1000);
   }
}

// Wykonywana automatycznie, kiedy z serwera otrzymywany jest komunikat
function processResults() 
{
   // Przejście dalej tylko wtedy, gdy transakcja została zakończona
   if (request.readyState == 4) 
   {
      // Wartość 200 właściwości status wskazuje na to, że wykonanie transakcji się powiodło
      if (request.status == 200) 
      {
         // Ekstrakcja XML pobranego z serwera
         var textResponse = request.responseText;
         alert('Uaktualnienie kanału');
         document.getElementById('displayResults').innerHTML = textResponse;
     
         // Otrzymanie elementu głównego dokumentu dla struktury XML

         // Uaktualnienie danych wyświetlanych klientowi za pomocą danych otrzymanych z serwera
      } 
      // Status HTTP inny od 200 wskazuje na wystąpienie błędu
      else 
      {
         alert("Wystąpił błąd w dostępie do serwera: " + request.statusText);
      }
   }
}