/*
Skrypt dodaje kilka uytecznych metod do obiektu tablicy jzyka JavaScript. Wszystkie operacje
dotycz wbudowanej klasy Array, zatem nie jest potrzebna adna dodatkowa przestrze nazw.

Dave Crane 2005
*/

/*
dodaje element na kocu tablicy, opcjonalnie sprawdzajc czy dany obiekt ju nie wystpuje
*/
Array.prototype.append=function(obj,nodup){
  if (!(nodup && this.contains(obj))){
    this[this.length]=obj;
  }
}

/*
zwraca indeks podanego elementu w tablicy 
*/
Array.prototype.indexOf=function(obj){
  var result=-1;
  for (var i=0;i<this.length;i++){
    if (this[i]==obj){
      result=i;
      break;
    }
  }
  return result;
}

/*
zwraca tru jeli przekazany element istnieje w tablicy  
*/
Array.prototype.contains=function(obj){
  return (this.indexOf(obj)>=0);
}

/*
usuwa ca zawarto tablicy
*/
Array.prototype.clear=function(){
  this.length=0;
}

/*
dodaje element do tablicy umieszczaj go pod odpowiednim indeksem,
wszystkie kolejne elementy s odpowiednio przesuwane 
*/
Array.prototype.insertAt=function(index,obj){
  this.splice(index,0,obj);
}

/*
usuwa z tablicy element o podanym indeksie
*/
Array.prototype.removeAt=function(index){
  this.splice(index,1);
}

/*
usuwa wskazany element tabeli
*/
Array.prototype.remove=function(obj){
  var index=this.indexOf(obj);
  if (index>=0){
    this.removeAt(index);
  }
}
