/*
biblioteka javascript 

funckcje pomocnicze do okrelania stylw wzw
*/

var styling=new Object();

/* okrela nieprzezroczysto (opacity) wza DOM przypisujc mu podan warto.
   
set the opacity of a DOM node to a given value, applying the css3 standard
@param opacity warto z zakresu od 0 do 1
*/
styling.opacity=function(ele,opacity){
  ele.style.opacity=opacity;
  ele.style.mozOpacity=opacity;
  ele.style.filter="alpha(opacity="+(opacity*100)+")";
}

/*podnosi element w drzewie DOM poprzez podczenie go bezporednio do jego "dziada", odpowiednio
  aktualizuje pooenie elementu
*/
styling.promote=function(ele){
  var par=ele.parent;
  if (par){
    var gpar=par.parent;
    if (gpar){
      par.removeChild(ele);
      gpar.appendChild(ele);
    }
  }
}

/*
jeli to konieczne to zapisuje argument jako element DOM; jeli element ju jest elementem DOM, nic nie robi.
Uywana by upewni si, e argument moe by bezpiecznie przekazany do funkcji wymagajcej elementu DOM,
ktry mona zobaczy */
styling.toDOMElement=function(obj,wrapperType){
  var result=null;
  if (obj instanceof Element){
    result=obj;
  }else{
    var txtNode=document.createTextNode(""+obj);
    if (wrapperType){
      var wrapper=document.createElement('div');
      wrapper.appendChild(txtNode);
      result=wrapper;
    }else{
      result=txtNode;
    }
  }
  return result;
}

/*usuniwa wszystkie wzy potomkw z danego wza*/
styling.removeAllChildren=function(ele){
  if (ele){
    while(ele.firstChild){
      ele.removeChild(ele.firstChild);
    }
  }
}

styling.insertAtTop=function(parent,child){
  if (parent.firstChild){
    parent.insertBefore(child,parent.firstChild);
  }else{
    parent.appendChild(child);
  }
}