//--- obiekt pojemnika
function Container(id){
  this.id=id;
  this.body=document.getElementById(id);
  this.boxes=new Array();
}

Container.prototype.add=function(box){
  this.boxes[this.boxes.length]=box;
  this.body.appendChild(box.body);
}

Container.prototype.clear=function(){
  for(var i=0;i<this.boxes.length;i++){
    this.boxes[i].hide();
  }
  this.boxes=new Array();
  report("clear");
  newDOMs=0;
  reusedDOMs=0;
}

//--- definiuje prosty obiekt czcy obiekt wspierajcy z interaktywny elementem interfejsu uytkownika 
//NB: Nie zawiera referencji do pojemnika w ktrym obiekt jest umieszczony
function ClickBox(container){
  this.size=40;
  this.x=5+Math.floor(Math.random()*370);
  this.y=5+Math.floor(Math.random()*370);
  this.id="box"+container.boxes.length;
  this.state=0;
  this.render();
  container.add(this);
}

//stara si uywa martwych wzw DOM jeli to tylko moliwe i prawidowe
ClickBox.prototype.render=function(){
  this.body=null;
  if (reuseDOM){
    this.body=document.getElementById(this.id);
  }
  if (this.body==null){
    this.body=document.createElement("div");
    this.body.id=this.id;
    newDOMs++;
  }else{
    reusedDOMs++;
  }
  this.body.backingObj=this;
  this.body.className='box1';
  this.body.style.left=this.x+"px";
  this.body.style.top=this.y+"px";
  this.body.onclick=function(){
    var clickbox=this.backingObj;
    clickbox.incrementState();
  }
}

ClickBox.prototype.incrementState=function(){
  if (this.state==0){
    this.body.className='box2';
  }else if (this.state==1){
    this.body.className='box3';
  }
  this.state++;
}

ClickBox.prototype.hide=function(){
  var bod=this.body;
  bod.className='box3';
  if (unlinkOnHide){
    bod.parentNode.removeChild(bod);
  }
  if (breakCyclics){
    bod.backingObj=null;
    this.body=null;
  }
}

//--- dodaje kilka prostoktw do pojemnika
function populate(count){
  var box=null;
  for(var i=0;i<count;i++){
    box=new ClickBox(container);
  }
  report("generacja");
  newDOMs=0;
  reusedDOMs=0;
}

function submitForm(){
    var count=document.myform.elements['boxCount'].value;
    if (count<1){
      alert("prosz podawa tylko liczby wiksze do zera");
    }else{
      populate(count);
    }
}

function debug(msg){
  debugPane.innerHTML+="<br>"+msg;
}

function report(title){
  debug("<b>"+title+"</b>");
  debug("ilo nowych utworzonych elementw DOM : "+newDOMs);
  debug("ilo ponownie uytych elementw DOM : "+reusedDOMs);
  debug("ilo potomkw kontenera : "+container.body.childNodes.length);
}

var container=null;  //globalna referencja do pojemnika
var debugPane=null;
window.onload=function(){
  container=new Container('container');
  debugPane=document.getElementById('debug');
}

var reuseDOM=false;    //jeli true, to stara si uywa istniejcych elementw DOM zanim zacznie tworzy nowe prostokty
var unlinkOnHide=false;//jeli true, to przed usuniciem prostokta zostanie on odczony od elementu DOM
var breakCyclics=false; //jeli true, to podczas usuwania prostoktw cykliczne referencje pomidzy elementami DOM i elementami nie nalecymi do DOM bd jawnie przerywane

function setReuseDOM(){ reuseDOM=document.myform.elements['reuseDOM'].checked; debug("reuse DOM ? "+reuseDOM); }
function setUnlinkOnHide(){ unlinkOnHide=document.myform.elements['unlinkOnHide'].checked; debug("unlink on hide ? "+unlinkOnHide);  }
function setBreakCyclics(){ breakCyclics=document.myform.elements['breakCyclics'].checked; debug("break cyclics ? "+breakCyclics); }

var newDOMs=0;
var reusedDOMs=0;

function stressTest(){
  for (var i=0;i<240;i++){
     populate(100);
     populate(100);
     container.clear();
  }
  alert("gotowe");
}
