/*
biblioteka javascript

oglny obiekt okna - window
*/

var windows=new Object();

/*globalne indeksy z-order */
windows.Z_UNFOCUS_FOLDER=1;
windows.Z_UNFOCUS_EXTRAS=2;
windows.Z_FOCUS_FOLDER=3;
windows.Z_FOCUS_EXTRAS=4;
windows.focused=null;
windows.windows=new Array();

/* funkcja konstruktoa obiektu*/
windows.Window=function(winEl,displayStr,x,y,w,h){
  windows.windows[windows.windows.length]=this;
  this.displayStr=displayStr;

  this.body=xGetElementById(winEl);
  if (!this.body){
    this.body=document.createElement("div");
    document.body.appendChild(this.body);
  }
  if (!this.body.className){
    this.body.className="window";
  }
  if (x && y){
    xMoveTo(this.body,x,y);
  }
  if (w && h){
    xResizeTo(this.body,w,h);
  }

  this.body.windowModel=this;
  xAddEventListener(this.body,'click',this.bodyOnClick,false);

  this.dragbar=document.createElement("div");
  this.body.parentNode.appendChild(this.dragbar);
  this.dragbar.className='dragbar';
  this.dragbar.windowModel=this;
  xEnableDrag(this.dragbar,null,this.barOnDrag,null);

  this.titlebar=document.createElement("div");
  this.body.parentNode.appendChild(this.titlebar);
  this.titlebar.className='titlebar';
  this.titlebar.windowModel=this;
  this.titlebar.appendChild(document.createTextNode(displayStr));
  xEnableDrag(this.titlebar,null,this.titleOnDrag,null);

  this.resize();
  this.bringToFront();

}

/*procedura obsugi zdarze: przesuwa okno podczas przecigania paska tytuowego */
windows.Window.prototype.titleOnDrag=function(ele, mdx, mdy){
  var windowModel=ele.windowModel;
  if (windowModel){
    windowModel.bringToFront();
    var body=windowModel.body;
    if (body){
      xMoveTo(body, xLeft(body) + mdx, xTop(body) + mdy);
      windowModel.resize();
    }
  }
}

/*procedura obsugi zdarze: zmienia wielko okna podczas przecigania uchwytu */
windows.Window.prototype.barOnDrag=function(ele, mdx, mdy){
  var windowModel=ele.windowModel;
  if (windowModel){
    windowModel.bringToFront();
    var body=windowModel.body;
    if (body){
      xResizeTo(body, xWidth(body) + mdx, xHeight(body) + mdy);
      windowModel.resize();
    }
  }
}

/*procedura obsugi zdarze: obsuga zdarze onclick dla caej kontrolki okna, implementujca polityk "kliknij by otworzy"*/
windows.Window.prototype.bodyOnClick=function(e){
  var event=new xEvent(e);
  var ele=event.target;
  var windowModel=ele.windowModel;
  if (windowModel){
    windowModel.bringToFront();
  }
}

/*zmienia wielko folderu i programowo zmienia pooenie tych elementw, ktrych rozmieszczenie przy uyciu CSS jest zbyt skomplikowane.*/
windows.Window.prototype.resize=function(){
  var bod=this.body;
  if (this.dragbar){
    var db=this.dragbar;
    xMoveTo(db, xLeft(bod)+xWidth(bod)-(xWidth(db)/2), xTop(bod)+xHeight(bod)-(xHeight(db)/2));
  }
  if (this.titlebar){
    var tb=this.titlebar;
    xMoveTo(tb, xLeft(bod)+12, xTop(bod));
    xResizeTo(tb,xWidth(bod)-30,16)
  }
  //zostawiamy moliwo zmiany wielkoci zawartoci w konkretnym oknie 
  if (this.resizeContents){
    this.resizeContents(this);
  }
}

/*domylna zmiana wielkoci zawartoci okna dopasowuje pierwszego potomka do elementu body, zakadajc e jest to jedyny potomek*/
windows.Window.prototype.resizeContents=function(){
  var bod=this.body;
  var content=bod.firstChild;
  while(content && content.nodeType!=1 && content.nextSibling){
    content=content.nextSibling;
  }
  if (content){
    xMoveTo(content,6,6);
    xResizeTo(content,xWidth(bod)-12,xHeight(bod)-12);
  }
}

/*
przenosi folder na wierzch stosu z-order, a folder, ktry wczeniej by na wierzchu, przenosi pod spd.
Ta metoda bdzie czsto wywoywana podczas przecigania, dlatego warto zwrci uwag na warunek
koczcy jej wykonywanie umieszczony na samym pocztku funkcji*/
windows.Window.prototype.bringToFront=function(){
  if (this==windows.focused){
    return;
  }
  if (windows.focused){
    windows.focused.unfocus();
  }
  windows.focused=this;
  this.focus();
}

/*ustawienie fokusu na folderze*/
windows.Window.prototype.focus=function(){
  xZIndex(this.body,windows.Z_FOCUS_FOLDER);
  xZIndex(this.dragbar,windows.Z_FOCUS_EXTRAS);
  xZIndex(this.titlebar,windows.Z_FOCUS_EXTRAS);
}

/*usunicie fokusu z folderu*/
windows.Window.prototype.unfocus=function(){
  xZIndex(this.body,windows.Z_UNFOCUS_FOLDER);
  xZIndex(this.dragbar,windows.Z_UNFOCUS_EXTRAS);
  xZIndex(this.titlebar,windows.Z_UNFOCUS_EXTRAS);
}

