/*
Obiekt EventRoutre stanowicy doskona, dziaajc w rnych przegldarkach, implementacj
wzorca projektowego Observer i korzystajcy z 'klasycznego' sposobu obsugi zdarze w jzyku 
JavaScript (nowsze metody addEventListener() oraz attachEvent() dziaaj w podobny sposb,
lecz maj pewne niedokonaoci, wicej informacji na ten temat znajdziesz na stronie
Quirskmode  [http://www.quirksmode.org/js/events_advanced.html].

Wymagane extras-array.js

Dave Crane 2005
*/

/* obiekt przestrzeni nazw */
var jsEvent=new Array();

/*
funkcja kontruktora, naley pda element DOM (lub inny obiekt) ktry bdzie obserwowany 
oraz typ zdarzenia, przy czym powinna to by poprawna nazwa rozpoznawana przez 
przegldark, np.: 'onmouseover' 'onclick' dla zdarze zwizanych z DOM-em.
*/
jsEvent.EventRouter=function(el,eventType){
  this.lsnrs=new Array();
  this.el=el;
  el.eventRouter=this;
  el[eventType]=jsEvent.EventRouter.callback;
}

/*
metoda pomocnicza suca do dodawania obiornikw zdarze 
*/
jsEvent.EventRouter.prototype.addListener=function(lsnr){
  this.lsnrs.append(lsnr,true);
}

/*
metoda pomocnicza suca do usuwania obiornikw zdarze 
*/
jsEvent.EventRouter.prototype.removeListener=function(lsnr){
  this.lsnrs.remove(lsnr);
}

/*
funkcja powiadamia wszystkie odbiorniki o fakcie pojawienia si zgoszenia 
jest ona wywoywana przez funkcj zwrotn, wic nie ma potrzeby by wywoywa 
j samodzielnie
*/
jsEvent.EventRouter.prototype.notify=function(e){
  var lsnrs=this.lsnrs;
  for(var i=0;i<lsnrs.length;i++){
    var lsnr=lsnrs[i];
    if (lsnr && lsnr.call){
      lsnr.call(this,e);
    }
  }
}

/*
'statyczna' funckja zwrotna obsugujca zdarzenia, dla ktrej obiektem 'this' bdzie element DOM.
Wystarczy okreli referencj do obiektu routera i uy jej do wywoania metody notify(). 
*/
jsEvent.EventRouter.callback=function(event){
  var e=event || window.event;
  var router=this.eventRouter;
  router.notify(e)
}

