from airflow import DAG
from airflow.providers.common.sql.operators.sql import (
    SQLColumnCheckOperator,
    SQLTableCheckOperator
)
    
with DAG(dag_id="column_and_table_check", start_date=None, schedule=None, 
         tags=["r6", "with"]):   
    t_check_col_mapping = SQLColumnCheckOperator(
        task_id="check_col_mapping",
        conn_id="example_db_postgres",
        table="customers",
        column_mapping={
            "loyalty_points": {
                'min': {'geq_to': 0},
                'max': {'less_than': 400, 'tolerance': 0.15},
            },
            "first_name": {
                "null_check": {'equal_to': 0}
            },
            "status": {
                "distinct_check": {'equal_to': 3}
            }
        }
    )
    
    t_check_table = SQLTableCheckOperator(
        task_id="check_table",
        conn_id="example_db_postgres",
        table="customers",
        checks={
            "no_points" : {
                "check_statement": "loyalty_points = 0",
                "partition_clause": "status = 'pending'"
                },
            "email_from_example": {
                "check_statement": "email LIKE '%@example.com'"
            }
        }
    )
    
t_check_col_mapping >> t_check_table