from airflow.decorators import dag, task
from airflow.operators.empty import EmptyOperator

@dag(dag_id="bash_graph_tf", start_date=None, schedule=None,
     tags=["r2", "taskflow"],
     template_searchpath=["/airflow-sandbox/external-scripts/"])
def bash_graph_tf():
     @task.bash
     def t_echo():
          return "echo 'Hello, Airflow!'"
     
     @task.bash
     def t_script():
          return "scripts/check_hosts.sh"
     
     @task.bash
     def t_script_path():
          return "show_date.sh"
     
     t_start = EmptyOperator(task_id="start")
     t_echo = t_echo()
     t_script = t_script()
     t_script_path = t_script_path()
     
     t_start.set_downstream(t_echo)
     t_echo.set_downstream([t_script, t_script_path])
    
bash_graph_tf()