from airflow.decorators import dag, task
from airflow.operators.bash import BashOperator
from airflow.models import Param
from datetime import datetime

DAG_params = {
    "example_date": Param(f"{datetime.now()}", type="string",
                          format="date-time",
                          description="Przykładowa data i czas"),
    
    "example_regex": Param("A100", type="string",
                           regex='^[A-Za-z0-9]+$',
                           description="Przykładowa txt + wyrażenie regularne"),
    
    "example_int": Param(10, type="integer", minimum=5, maximum=25,
                         multipleOf=5,
                         description="Przykładowy integer"),
    
    "example_enum": Param("A", type="string", enum=["A", "B", "C"],
                          description="Przykładowy enum"),
    
    "example_bool": Param(True, type="boolean",
                          description="Przykładowy True/False")
}

    
@dag(dag_id="dag_config_example_tf", start_date=None, schedule=None, 
     tags=["r5", "taskflow"], params=DAG_params)
def dag_config_example_tf():
    @task
    def get_params(**context):
        my_param = context["params"]
    
        print(my_param["example_date"])
        print(my_param["example_int"])
    
    @task.bash
    def bash_params():
        return "echo '{{ params.example_regex }}' '{{ params.example_enum }}'"
    
    
    t_python_params = get_params()
    t_bash_params = bash_params()
    
    t_python_params
    t_bash_params
    
dag_config_example_tf()

