//----------------------------------------------
//
// FSM:       Turnstile
// Context:   TurnstileActions
// Exception: FSMError
// Version:
// Generated: Monday 07/18/2005 at 20:57:53 CDT
//
//----------------------------------------------

//----------------------------------------------
//
// class Turnstile
//    This is the Finite State Machine class
//
public class Turnstile : TurnstileActions
{
  private State itsState;
  private static string itsVersion = " ";

  // instance variables for each state
  private Unlocked itsUnlockedState;
  private Locked itsLockedState;

  // constructor
  public Turnstile()
  {
    itsUnlockedState = new Unlocked();
    itsLockedState = new Locked();

    itsState = itsLockedState;

    // Entry functions for: Locked
  }

  // accessor functions

  public string GetVersion()
  {
    return itsVersion;
  }
  public string GetCurrentStateName()
  {
    return itsState.StateName();
  }
  public State GetCurrentState()
  {
    return itsState;
  }
  public State GetItsUnlockedState()
  {
    return itsUnlockedState;
  }
  public State GetItsLockedState()
  {
    return itsLockedState;
  }

  // Mutator functions

  public void SetState(State value)
  {
    itsState = value;
  }
  // event functions - forward to the current State

  public void Pass()
  {
    itsState.Pass(this);
  }
  public void Coin()
  {
    itsState.Coin(this);
  }

}
//--------------------------------------------
//
// public class State
//    This is the base State class
//
public abstract class State
{
  public abstract string StateName();

  // default event functions

  public virtual void Pass(Turnstile name)
  {
    throw new FSMError( "Pass", name.GetCurrentState());
  }
  public virtual void Coin(Turnstile name)
  {
    throw new FSMError( "Coin", name.GetCurrentState());
  }
}
//--------------------------------------------
//
// class Unlocked
//    handles the Unlocked State and its events
//
public class Unlocked : State
{
  public override string StateName()
    { return "Unlocked"; }

  //
  // responds to Coin event
  //
  public override void Coin(Turnstile name)
  {
    name.Thankyou();

    // change the state
    name.SetState(name.GetItsUnlockedState());
  }

  //
  // responds to Pass event
  //
  public override void Pass(Turnstile name)
  {
    name.Lock();
     // change the state
     name.SetState(name.GetItsLockedState());
  }
}

//--------------------------------------------
//
// class Locked
//    handles the Locked State and its events
//
public class Locked : State
{
  public override string StateName()
    { return "Locked"; }

  //
  // responds to Coin event
  //
  public override void Coin(Turnstile name)
  {
    name.Unlock();

    // change the state
    name.SetState(name.GetItsUnlockedState());
  }

  //
  // responds to Pass event
  //
  public override void Pass(Turnstile name)
  {
    name.Alarm();

    // change the state
    name.SetState(name.GetItsLockedState());
  }
}
