using System;
using NUnit.Framework;

[TestFixture]
public class TestSleepCommand
{
  private class WakeUpCommand : Command
  {
    public bool executed = false;

    public void Execute()
    {
      executed = true;
    }
  }

  [Test]
  public void TestSleep()
  {
    WakeUpCommand wakeup = new WakeUpCommand();
    ActiveObjectEngine e = new ActiveObjectEngine();
    SleepCommand c = new SleepCommand(1000, e, wakeup);
    e.AddCommand(c);
    DateTime start = DateTime.Now;
    e.Run();
    DateTime stop = DateTime.Now;
    double sleepTime = (stop-start).TotalMilliseconds;
    Assert.IsTrue(sleepTime >= 1000,
      "Oczekiwano czasu wstrzymania pracy SleepTime: " + sleepTime +
        " wikszego od 1000");
    Assert.IsTrue(sleepTime <= 1100,
      "Oczekiwano czasu wstrzymania pracy SleepTime: " + sleepTime +
        " mniejszego od 1100");
    Assert.IsTrue(wakeup.executed, "Metoda Execute zostaa wywoana.");
  }
}
