/// <remark>
/// Klasa PrimeGenerator generuje liczby pierwsze od 1 do wartoci
/// maksymalnej okrelonej przez uytkownika. Ponisza klasa
/// wykorzystuje klasyczny algorytm sita Eratostenesa. Pocztkowo dysponujemy
/// tablic kolejnych liczb cakowitych (poczwszy do 2). Usuwamy z tej
/// tablicy wszystkie wielokrotnoci dwjki i przechodzimy do kolejnej
/// liczby cakowitej, by usun jej wielokrotnoci. Powtarzamy t procedur
/// a do osignicia wartoci rwnej pierwiastkowi kwadratowemu liczby
/// maksymalnej.
/// </remark>
using System;

public class PrimeGenerator
{
  private static int s;
  private static bool[] f;
  private static int[] primes;

  public static int[] GeneratePrimeNumbers(int maxValue)
  {
    if (maxValue < 2)
      return new int[0];
    else
    {
      InitializeSieve(maxValue);
      Sieve();
      LoadPrimes();
      return primes;  // Zwraca liczby pierwsze.
    }
  }
  private static void LoadPrimes()
  {
    int i;
    int j;
    // Ile liczb pierwszych zostao w naszej tablicy?
    int count = 0;
    for (i = 0; i < s; i++)
    {
      if (f[i])
        count++; // zwikszajcy si licznik
    }

    primes = new int[count];

    // Przenosimy liczby pierwsze do tablicy wynikowej.
    for (i = 0, j = 0; i < s; i++)
    {
      if (f[i])             // Jeli i jest liczb pierwsz
        primes[j++] = i;
    }
  }

  private static void Sieve()
  {
    int i;
    int j;
    for (i = 2; i < Math.Sqrt(s) + 1; i++)
    {
      if(f[i]) // Jeli i nie zostao wyeliminowane, eliminujemy jego wielokrotnoci.
      {
        for (j = 2 * i; j < s; j += i)
          f[j] = false; // Wielokrotno i nie moe by liczb pierwsz.
      }
    }
  }

  private static void InitializeSieve(int maxValue)
  {
    // deklaracje
    s = maxValue + 1; // rozmiar tablicy
    f = new bool[s];
    int i;

    // Inicjalizuje tablic wartoci true.
    for (i = 0; i < s; i++)
      f[i] = true;

    // Eliminuje znane liczby niepierwsze.
    f[0] = f[1] = false;
  }
}
