class Shipping
    ShippingOption = Struct.new(:id, :name)

    class ShippingType
      attr_reader :type_name, :options
      def initialize(name)
        @type_name = name
        @options = []
      end
      def <<(option)
        @options << option
      end
    end


    ground    = ShippingType.new("WOLNA")
    ground   << ShippingOption.new(100, "List zwykły")
    ground   << ShippingOption.new(101, "Paczka")

    regular   = ShippingType.new("NORMALNA")
    regular  << ShippingOption.new(200, "Przesyłka lotnicza")
    regular  << ShippingOption.new(201, "Przesyłka polecona")
    
    priority  = ShippingType.new("SZYBKA")
    priority << ShippingOption.new(300, "Priorytet")
    priority << ShippingOption.new(301, "Ekspres")
    
    OPTIONS = [ ground, regular, priority ]

end
