ActionController::Routing::Routes.draw do |map|

  # Adres http://moja.aplikacja/blog/ wyświetla stronę indeksu
  map.connect "blog/",
              :controller   => "blog",
              :action       => "index"
  
  # Artykuły dla danego roku, roku/miesiąca lub roku/miesiąca/dnia
  map.connect "blog/:year/:month/:day",
              :controller   => "blog",
              :action       => "show_date",
              :requirements => { :year  => /(19|20)\d\d/,
                                 :month => /[01]?\d/,
                                 :day   => /[0-3]?\d/},
              :day          => nil,
              :month        => nil

  # Artykuł o podanym identyfikatorze
  map.connect "blog/show/:id",
              :controller   => "blog",
              :action       => "show",
              :id           => /\d+/

  # Routing funkcji administracyjnych
  map.connect "blog/:controller/:action/:id"

  # Zbiorcza obsługa nieprawidłowych żądań
  map.connect "*anything",
              :controller   => "blog",
              :action       => "unknown_request"
end

