class ArticleSweeper < ActionController::Caching::Sweeper
  observe Article

  # Gdy utworzymy nowy artykuł, publiczna lista musi zostać odtworzona
  def after_create(article)
    expire_public_page
  end

  # Gdy zaktualizujemy istniejący artykuł, jego buforowana wersja stanie się przestarzała
  def after_update(article)
    expire_article_page(article.id)
  end

  # Usunięcie strony oznacza, że musimy zaktualizować publiczną listę i usunąć artykuł z pamięci podręcznej
  def after_destroy(article)
    expire_public_page
    expire_article_page(article.id)
  end

  private

  def expire_public_page
    expire_page(:controller => "content", :action => 'public_content')
  end

  def expire_article_page(article_id)
    expire_action(:controller => "content",
                  :action     => "premium_content",
                  :id         => article_id)
  end
end

