class Article
  PUBLIC = []
  PREMIUM = []
  def self.list_public
    PUBLIC
  end
  def self.list_premium
    PREMIUM
  end
  def initialize(arg)
    @when = Time.now
  end
  def save
    PUBLIC << self
  end
  def find(a)
  end
end

class User
  def active?
    true
  end
  def find(a)
    self.new
  end
end

class ContentController < ApplicationController
  before_filter :verify_premium_user, :except => :public_content

  caches_page   :public_content
  caches_action :premium_content
  def public_content
    @articles = Article.list_public
  end

  def premium_content
    @articles = Article.list_premium
  end

  def create_article
    article = Article.new(params[:article])
    if article.save
      expire_page   :action => "public_content"
    else
      # ...
    end
  end

  def update_article
    article = Article.new(params[:article])
    if article.save
      expire_action :action => "premium_content", :id => article
    else
      # ...
    end
  end
  def delete_article
    Article.destroy(params[:id])
    expire_page   :action => "public_content"
    expire_action :action => "premium_content", :id => params[:id]
  end

  private

  def verify_premium_user
    user = session[:user_id]
    user = User.find(user) if user
    unless user && user.active?
      redirect_to :controller => "login", :action => "signup_new"
    end
  end
end
