$: << File.dirname(__FILE__)
require "connect"
require "logger"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"


ActiveRecord::Schema.define do 
  # START:migration
  create_table :accounts, :force => true do |t|
    t.column :number, :string
    t.column :balance, :decimal, :precision => 10, :scale => 2, :default => 0
  end
  # END:migration
end


class Account < ActiveRecord::Base
  def self.transfer(from, to, amount)
    transaction(from, to) do
      from.withdraw(amount)
      to.deposit(amount)
    end
  end

  def withdraw(amount)
    adjust_balance_and_save(-amount)
  end

  def deposit(amount)
    adjust_balance_and_save(amount)
  end

  private

  def adjust_balance_and_save(amount)
    self.balance += amount
    save!
  end

  def validate # walidacja wywoływana przez Active Record
    errors.add(:balance, "jest ujemny") if balance < 0
  end

end

  def adjust_balance_and_save(amount)
    self.balance += amount
  end

pawel = Account.create(:balance => 100, :number => "12345")
piotr  = Account.create(:balance => 200, :number => "54321")

case ARGV[0] || "1"

when "1"
  Account.transaction do
    pawel.deposit(10)
    piotr.withdraw(10)
  end

when "2"
  Account.transaction do
    pawel.deposit(350)
    piotr.withdraw(350)
  end

when "3"
  begin
    Account.transaction do
      pawel.deposit(350)
      piotr.withdraw(350)
    end
  rescue
    puts "Transfer został przerwany"
  end
  
  puts "Bilans Pawła: #{pawel.balance}"
  puts "Bilans Piotra: #{piotr.balance}"

when "4"
  begin
    Account.transaction(pawel, piotr) do
      pawel.deposit(350)
      piotr.withdraw(350)
    end
  rescue
    puts "Transfer został przerwany"
  end
  
  puts "Bilans Pawła: #{pawel.balance}"
  puts "Bilans Piotra: #{piotr.balance}"
  
when "5"
  Account.transfer(pawel, piotr, 350) rescue  puts "Transfer został przerwany"
  
  puts "Bilans Pawła: #{pawel.balance}"
  puts "Bilans Piotra: #{piotr.balance}"

end



