$: << File.dirname(__FILE__)
require "connect"
require "logger"

#ActiveRecord::Base.logger = Logger.new(STDOUT)

require "rubygems"

class Employee < ActiveRecord::Base
  belongs_to :manager,
             :class_name  => "Employee",
             :foreign_key => "manager_id"

  belongs_to :mentor,
             :class_name  => "Employee", 
             :foreign_key => "mentor_id"
  
  has_many   :mentored_employees,
             :class_name  => "Employee",
             :foreign_key => "mentor_id"

  has_many   :managed_employees,
             :class_name  => "Employee",
             :foreign_key => "manager_id"
end

Employee.delete_all

adam  = Employee.create(:id => 1, :name => "Adam")
beata = Employee.create(:id => 2, :name => "Beata")

anna = Employee.new(:name => "Anna")
anna.manager = adam
anna.mentor  = beata
anna.save!

daniel = Employee.new(:name => "Daniel")
daniel.manager = adam
daniel.mentor  = anna
daniel.save!

p adam.managed_employees.map {|e| e.name}  # => podwładni Adama: [ "Anna", "Daniel" ]
p adam.mentored_employees                  # => osoby, którym doradza Adam: []
p daniel.mentor.name                       # => doradca Daniela: "Anna"


