$: << File.dirname(__FILE__)
require "connect"
require "logger"

ActiveRecord::Base.logger = Logger.new(STDOUT)

# START:define
require "rubygems"
require "pp"

@params = {}
def params
  @params
end

class Order < ActiveRecord::Base
end

class LineItem < ActiveRecord::Base
end

class Product < ActiveRecord::Base
end

# zwróć konkretne zamówienie
order = Order.find(:first)

# zwróć zamówienie złożone przez Adama
order = Order.find(:first, :conditions => "name = 'Adam Nowak'")

# zwróć ostatnie zamówienie złożone przez Adama
order = Order.find(:first,
                   :conditions => "name = 'Adam Nowak'",
                   :order => "id DESC")


orders = LineItem.find_by_sql("select line_items.* from line_items, orders " +
                              " where order_id = orders.id                 " +
                              " and orders.name = 'Adam Nowak'             ")


orders = Order.find_by_sql("select name, pay_type from orders")
first = orders[0]
p first.attributes
p first.attribute_names
p first.attribute_present?("address")


Product.delete_all
LineItem.delete_all
p = Product.create(:title => "Programowanie w języku Ruby", :date_available => Time.now)
LineItem.create(:quantity => 2, :unit_price => 44.95, :product_id => p.id)

items = LineItem.find_by_sql("select *,                                  " +
                             "       quantity*unit_price as total_price, " +
                             "       products.title as title             " +
                             "  from line_items, products                " +
                             " where line_items.product_id = products.id ")
li = items[0]
puts "#{li.title}: #{li.quantity}x#{li.unit_price} => #{li.total_price}"


c1 = Order.count
c2 = Order.count(["name = ?", "Adam Nowak"])
c3 = LineItem.count_by_sql("select count(*)                        " +
                           "  from line_items, orders              " +
                           " where line_items.order_id = orders.id " +
                           "   and orders.name = 'Adam Nowak'      ")
puts "Adam ma #{c3} pozycji w #{c2} zamówieniach (zamówień razem: #{c1})"

order  = Order.find_by_name("Jan Kowalski")
orders = Order.find_all_by_name("Jan Kowalski")
order  = Order.find_all_by_email(params['email'])

o = LineItem.find(:all,
                  :conditions => "pr.title = 'Programowanie w języku Ruby",
                  :joins => "as li inner join products as pr on li.product_id = pr.id")
p o.size


res = Order.update_all("pay_type = 'blabla'")
p res

res = Order.delete_all(["pay_type = ?", "blabla"])
p res

